---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：4-ドキュメント作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **既存ID検出時の409エラーの具体的なレスポンスメッセージ**：エンジン層の例外メッセージの正確性を確認する必要がある

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/create.json` - REST API仕様定義
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestIndexAction.java` - RESTハンドラ実装（CreateHandler: 78-102行目）
- E-03: `server/src/main/java/org/opensearch/action/index/IndexResponse.java` - レスポンスクラス
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは PUT/POST /{index}/_create/{id} | E-01, E-02 (87行目) | ○ |
| C-02 | 既存ID時に409エラーを返す | E-01 (description) | ○ |
| C-03 | リクエストボディは必須 | E-01 (body.required: true) | ○ |
| C-04 | op_typeをcreateに強制設定する | E-02 (93行目) | ○ |
| C-05 | validateOpTypeでcreate以外を拒否する | E-02 (97-101行目) | ○ |
| C-06 | 親クラスのprepareRequestに委譲する | E-02 (94行目) | ○ |
| C-07 | wait_for_active_shardsパラメータが存在する | E-01 | ○ |
| C-08 | refreshパラメータが存在する | E-01 | ○ |
| C-09 | pipelineパラメータが存在する | E-01 | ○ |
| C-10 | version/version_typeパラメータが存在する | E-01 | ○ |
| C-11 | 関連機能No.10が主機能 | E-05 | ○ |
| C-12 | 関連機能No.36が補助機能 | E-05 | ○ |
| C-13 | 成功時は201 Createdを返す | E-03 (result: CREATED) | ○ |
| C-14 | CreateHandlerはRestIndexActionの内部クラスである | E-02 (78行目) | ○ |
| C-15 | if_seq_no/if_primary_termはcreate API仕様に未定義 | E-01 (paramsにif_seq_no/if_primary_termが存在しない) | ○ |
| C-16 | 既存ID検出時のエラーメッセージが "document already exists" | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- VersionConflictEngineExceptionの具体的なメッセージフォーマットを確認していない
  - 候補：InternalEngine.java / VersionConflictEngineException.java の詳細読込

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・メソッド・パラメータの記述（API仕様とソースコードで確認済み）
- 0: CreateHandlerの処理フロー（ソースコードで確認済み）
- 1: エラーメッセージの正確性（一般的な知識に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] 既存IDで409エラーが返されることを動作確認する
- [ ] validateOpTypeのエラーメッセージが正確か確認する
- [ ] pipelineパラメータが_create パスでも機能することを確認する
