---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：41-インデックス存在確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **RestGetIndicesActionがHEADリクエストでTransportIndicesExistsActionを呼び出す経路**：内部的なディスパッチの詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.exists.json`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/exists/indices/TransportIndicesExistsAction.java`
- E-03: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndicesAction.java`
- E-04: `server/src/main/java/org/opensearch/action/ActionModule.java`（695行目）
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HEAD /{index} でインデックス存在確認ができる | E-01 | ○ |
| C-02 | パスパラメータにindex（list型）を取る | E-01 | ○ |
| C-03 | クエリパラメータにlocal, ignore_unavailable, allow_no_indices, expand_wildcards, flat_settings, include_defaultsがある | E-01 | ○ |
| C-04 | expand_wildcardsのデフォルトはopen | E-01 | ○ |
| C-05 | TransportIndicesExistsActionがSAMEスレッドプールで実行される | E-02（84-87行目） | ○ |
| C-06 | IndexNameExpressionResolver.concreteIndexNames()で存在確認する | E-02（119行目） | ○ |
| C-07 | IndexNotFoundExceptionで存在しないと判定する | E-02（121-122行目） | ○ |
| C-08 | ClusterBlockLevel.METADATA_READでブロックチェックする | E-02（105行目） | ○ |
| C-09 | RestGetIndicesActionがHEAD /{index}を処理する | E-03（65行目） | ○ |
| C-10 | ActionModuleで IndicesExistsAction が登録されている | E-04（695行目） | ○ |
| C-11 | 画面一覧でNo.41がインデックス存在確認である | E-05, E-06 | ○ |
| C-12 | RestGetIndicesActionからTransportIndicesExistsActionへの内部ディスパッチ経路 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-12について、RestGetIndicesActionがHEADリクエスト時に内部的にTransportIndicesExistsActionを利用する具体的なコード経路は確認できなかった。RestGetIndicesAction自体はGetIndexRequestを構築するが、HEAD時の挙動が存在確認に特化しているかはフレームワーク内部の処理による。
  - 候補：RestGetIndicesAction内のHEAD処理分岐 / BaseRestHandler内のHEAD処理 / NodeClient内のディスパッチロジック

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様（パラメータ、レスポンス）はREST APIスペックから直接確認済み
- 1: 中リスク - RESTハンドラからTransportアクションへの内部ディスパッチ経路の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] HEAD /{index} がRestGetIndicesActionで処理されることを確認
- [ ] TransportIndicesExistsActionの実行パスが正しく記載されているか確認
- [ ] クエリパラメータ一覧がAPIスペックと一致しているか確認
