---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：42-インデックスオープン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **MetadataIndexStateService.openIndex()の詳細ロジック**：直接のソースコード確認が未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.open.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestOpenIndexAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /{index}/_open でインデックスをオープンできる | E-01, E-02（67行目） | ○ |
| C-02 | timeout, cluster_manager_timeout, master_timeout(非推奨)パラメータがある | E-01 | ○ |
| C-03 | expand_wildcardsのデフォルトがclosed | E-01 | ○ |
| C-04 | wait_for_completion=falseで非同期実行可能 | E-01, E-02（88-109行目） | ○ |
| C-05 | task_execution_timeoutのデフォルトは1h | E-02（97行目: DEFAULT_TASK_EXECUTION_TIMEOUT） | ○ |
| C-06 | 非同期時にsetShouldStoreResult(true)が設定される | E-02（92行目） | ○ |
| C-07 | 非同期時にバリデーション例外チェックが行われる | E-02（102-105行目） | ○ |
| C-08 | wait_for_active_shardsパラメータが設定可能 | E-01, E-02（84-86行目） | ○ |
| C-09 | master_timeoutは2.0.0で非推奨 | E-01 | ○ |
| C-10 | レスポンスにacknowledgedとshards_acknowledgedが含まれる | E-02（89行目: RestToXContentListener） | ○ |
| C-11 | 画面一覧でNo.42がインデックスオープン | E-03 | ○ |
| C-12 | 機能No.3 インデックスオープン/クローズが主機能 | E-04 | ○ |
| C-13 | インデックスクローズ後にオープンで復帰する遷移 | E-05 | ○ |
| C-14 | MetadataIndexStateService.openIndex()でクラスタ状態を更新する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: MetadataIndexStateServiceの具体的な実装は直接読み込んでいないが、OpenSearchの標準的なインデックス状態管理パターンから推測した記述。
  - 候補：MetadataIndexStateService.java / TransportOpenIndexAction.java内部処理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - REST APIスペックとRESTハンドラのソースコードから大部分を確認済み
- 1: 中リスク - Transport層以降の内部処理詳細は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] POST /{index}/_open のパラメータ一覧がAPIスペックと一致しているか確認
- [ ] 非同期実行パス（wait_for_completion=false）の記述が正確か確認
- [ ] MetadataIndexStateService.openIndex()の呼び出し経路を確認
