---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：45-インデックスクローン

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **ハードリンクによるクローン実装の詳細**：TransportResizeAction内部の具体的実装は未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.clone.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestResizeHandler.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PUT/POST /{index}/_clone/{target} でクローンできる | E-01, E-02（189-190行目） | ○ |
| C-02 | indexとtargetのパスパラメータが必須 | E-01 | ○ |
| C-03 | timeout, cluster_manager_timeout, wait_for_active_shardsパラメータがある | E-01 | ○ |
| C-04 | wait_for_completion=falseで非同期実行可能 | E-01, E-02（108-130行目） | ○ |
| C-05 | task_execution_timeoutのデフォルトは1h | E-02（117行目: DEFAULT_TASK_EXECUTION_TIMEOUT） | ○ |
| C-06 | リクエストボディにsettingsとaliasesを指定可能 | E-01 | ○ |
| C-07 | RestCloneIndexActionがResizeType.CLONEを返す | E-02（199-200行目） | ○ |
| C-08 | copy_settingsにfalseを設定するとエラー | E-02（91-93行目） | ○ |
| C-09 | copy_settingsは非推奨（3.0.0で削除予定） | E-02（95-98行目） | ○ |
| C-10 | 画面一覧でNo.45がインデックスクローン | E-03 | ○ |
| C-11 | 機能No.1 インデックス作成が主機能、No.56 シャードアロケーションが補助機能 | E-04 | ○ |
| C-12 | インデックス作成後にクローンが可能（遷移関連） | E-05 | ○ |
| C-13 | ResizeRequestでtargetとindexを設定する | E-02（78行目） | ○ |
| C-14 | ハードリンクによる高速クローン | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: ハードリンクを使用したクローンの実装詳細はTransportResizeActionの内部処理に依存し、直接確認していない。OpenSearchの公式ドキュメントの記述に基づく。
  - 候補：TransportResizeAction.java / MetadataCreateIndexService.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIスペックとRESTハンドラから大部分を確認済み
- 1: 中リスク - クローンの内部実装（ハードリンク vs データコピー）の正確性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ一覧がAPIスペックと一致しているか確認
- [ ] ResizeType.CLONEの設定がRestCloneIndexActionで行われるか確認
- [ ] ソースインデックスのread_only前提条件の記述が正確か確認
