---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：46-インデックス縮小

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **シャード数が約数でなければならない制約の実装箇所**：TransportResizeAction内部の確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.shrink.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestResizeHandler.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PUT/POST /{index}/_shrink/{target} で縮小できる | E-01, E-02（141-142行目） | ○ |
| C-02 | copy_settingsパラメータがある（非推奨） | E-01, E-02（82-99行目） | ○ |
| C-03 | timeout, cluster_manager_timeout, wait_for_active_shardsパラメータがある | E-01 | ○ |
| C-04 | wait_for_completion=falseで非同期実行可能 | E-01, E-02（108-130行目） | ○ |
| C-05 | リクエストボディにsettingsとaliasesを指定可能 | E-01 | ○ |
| C-06 | RestShrinkIndexActionがResizeType.SHRINKを返す | E-02（151-152行目） | ○ |
| C-07 | 画面一覧でNo.46がインデックス縮小 | E-03 | ○ |
| C-08 | 機能No.6 インデックスシュリンク/スプリットが主機能 | E-04 | ○ |
| C-09 | copy_settingsにfalseを設定するとエラー | E-02（91-93行目） | ○ |
| C-10 | 非同期時にバリデーション例外チェックが行われる | E-02（122-125行目） | ○ |
| C-11 | task_execution_timeoutのデフォルトは1h | E-02（117行目） | ○ |
| C-12 | master_timeoutは2.0.0で非推奨 | E-01 | ○ |
| C-13 | ターゲットシャード数はソースの約数でなければならない | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: シャード数の約数制約はOpenSearchの公式ドキュメントの記述に基づくが、TransportResizeAction内部でのバリデーション処理は直接確認していない。
  - 候補：TransportResizeAction.java / MetadataCreateIndexService.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIスペックとRESTハンドラから大部分を確認済み
- 1: 中リスク - 縮小の前提条件（read_only、同一ノード配置）の正確性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ一覧がAPIスペックと一致しているか確認
- [ ] シャード数の約数制約が正確に記載されているか確認
- [ ] 前提条件（read_only、同一ノード配置）の記述を確認
