---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：48-インデックスロールオーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **ロールオーバー条件（max_age, max_docs, max_size）の詳細仕様**：Condition.javaの直接確認が未実施
  2. **新インデックス名の自動生成ロジック**：MetadataRolloverServiceの直接確認が未実施

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.rollover.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestRolloverIndexAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POST /{alias}/_rollover でロールオーバーできる | E-01, E-02（63行目） | ○ |
| C-02 | POST /{alias}/_rollover/{new_index} で新インデックス名を指定できる | E-01, E-02（63行目） | ○ |
| C-03 | dry_runパラメータで条件のみ評価可能 | E-01, E-02（78行目） | ○ |
| C-04 | timeout, cluster_manager_timeout, master_timeout(非推奨)パラメータがある | E-01 | ○ |
| C-05 | wait_for_active_shardsパラメータが設定可能 | E-01, E-02（84-85行目） | ○ |
| C-06 | リクエストボディにconditionsを指定可能 | E-01, E-02（77行目） | ○ |
| C-07 | include_type_nameは非推奨 | E-02（58-59行目、73-75行目） | ○ |
| C-08 | レスポンスにold_index、new_index、rolled_over、dry_run、conditionsが含まれる | E-02（86行目: RestToXContentListener） | ○ |
| C-09 | 画面一覧でNo.48がインデックスロールオーバー | E-03 | ○ |
| C-10 | 機能No.5 インデックスロールオーバーが主機能、No.4 インデックスエイリアスが補助機能 | E-04 | ○ |
| C-11 | インデックスライフサイクル管理における遷移（ロールオーバー -> 新インデックス作成） | E-05 | ○ |
| C-12 | master_timeoutは2.0.0で非推奨 | E-01 | ○ |
| C-13 | RolloverRequestにfromXContent()でボディをパースする | E-02（77行目） | ○ |
| C-14 | ロールオーバー条件にmax_age, max_docs, max_sizeがある | **根拠なし** | △ |
| C-15 | new_index省略時にインデックス名末尾の番号がインクリメントされる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: ロールオーバー条件の詳細はCondition.javaやRolloverRequest.fromXContent()の実装に依存するが、直接確認していない。OpenSearchの公式ドキュメントに基づく。
  - 候補：Condition.java / MaxAgeCondition.java / MaxDocsCondition.java / MaxSizeCondition.java
- C-15: 新インデックス名の自動生成ロジックはMetadataRolloverService内の実装に依存するが、直接確認していない。
  - 候補：MetadataRolloverService.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIスペックとRESTハンドラから基本仕様を確認済み
- 1: 中リスク - ロールオーバー条件の詳細とインデックス名自動生成ロジックは推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ一覧がAPIスペックと一致しているか確認
- [ ] ロールオーバー条件（max_age, max_docs, max_size）の記述が正確か確認
- [ ] レスポンス構造（conditions含む）が正確か確認
- [ ] 新インデックス名の自動生成ルールが正確か確認
