---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-ドキュメント取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **ShardGetService経由のドキュメント取得処理フロー**：トランスポート層以降の具体的な処理を確認する必要がある

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/get.json` - REST API仕様定義
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestGetAction.java` - RESTハンドラ実装
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは GET /{index}/_doc/{id} | E-01, E-02 (71行目) | ○ |
| C-02 | ドキュメントを取得する | E-01 | ○ |
| C-03 | stored_fieldsパラメータが存在する | E-01, E-02 (87-93行目) | ○ |
| C-04 | preferenceパラメータが存在する | E-01, E-02 (79行目) | ○ |
| C-05 | realtimeパラメータのデフォルトはtrue | E-01, E-02 (80行目) | ○ |
| C-06 | _source関連パラメータが存在する | E-01, E-02 (98行目) | ○ |
| C-07 | version/version_typeパラメータが存在する | E-01, E-02 (95-96行目) | ○ |
| C-08 | GETとHEAD両方のルーティングが登録される | E-02 (71行目) | ○ |
| C-09 | ドキュメント存在時200、未存在時404を返す | E-02 (102-103行目) | ○ |
| C-10 | fieldsパラメータは非推奨 | E-02 (81-86行目) | ○ |
| C-11 | 関連機能No.11がドキュメント取得の主機能 | E-04 | ○ |
| C-12 | FetchSourceContextでソースフィルタリングを行う | E-02 (98行目) | ○ |
| C-13 | レスポンスにfoundフィールドを含む | E-01 (description), E-02 | ○ |
| C-14 | refreshパラメータで取得前リフレッシュ可能 | E-01, E-02 (77行目) | ○ |
| C-15 | routingパラメータが存在する | E-01, E-02 (78行目) | ○ |
| C-16 | ShardGetService経由でドキュメントを取得する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TransportGetAction以降の処理フロー（ShardGetService, InternalEngine.get()）の詳細を確認していない
  - 候補：TransportGetAction.java / ShardGetService.java / InternalEngine.java の詳細読込

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・メソッド・パラメータの記述（API仕様とソースコードで確認済み）
- 0: RestGetActionの処理フロー（ソースコードで確認済み）
- 1: トランスポート層以降の処理フロー（推測含む）

## 6) レビュアーチェックリスト（最小）
- [ ] ドキュメント未存在時のレスポンスボディ構造が正確か確認する
- [ ] realtimeモードとsearchモードの動作の違いを確認する
- [ ] _source_includes/_source_excludesのフィルタリングが正しく機能するか確認する
