---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：51-マッピング更新

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **デフォルトタイムアウト値**：ソースコードで明示的な30sのデフォルト値が確認できない
  2. **Security Plugin権限名**：具体的なアクション名の根拠が直接ソースコード内に確認できない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_mapping.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestPutMappingAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/TransportPutMappingAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは PUT/POST /{index}/_mapping | E-01, E-02 | ○ |
| C-02 | _{index}/_mappings（複数形）パスも対応 | E-02 (行71-72) | ○ |
| C-03 | indexパラメータはlist型でカンマ区切り | E-01, E-02 (行85) | ○ |
| C-04 | timeoutパラメータが存在 | E-01, E-02 (行93) | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在 | E-01, E-02 (行94-96) | ○ |
| C-06 | master_timeoutは非推奨（v2.0.0） | E-01 | ○ |
| C-07 | ignore_unavailableパラメータが存在 | E-01, E-02 (行98) | ○ |
| C-08 | allow_no_indicesパラメータが存在 | E-01, E-02 (行98) | ○ |
| C-09 | expand_wildcardsのデフォルトはopen | E-01 | ○ |
| C-10 | write_index_onlyパラメータが存在しデフォルトfalse | E-01, E-02 (行99) | ○ |
| C-11 | リクエストボディは必須 | E-01 | ○ |
| C-12 | 型付きマッピングは拒否される | E-02 (行88-90) | ○ |
| C-13 | レスポンスに acknowledged フィールドが含まれる | E-02 (行100: RestToXContentListener) | ○ |
| C-14 | 関連機能はNo.17マッピング管理 | E-05 | ○ |
| C-15 | MetadataMappingServiceがマッピング更新を実行 | E-03 | ○ |
| C-16 | デフォルトタイムアウトが30s | **根拠なし** | △ |
| C-17 | Security Pluginで indices:admin/mapping/put 権限が必要 | **根拠なし** | △ |
| C-18 | MapperService.merge()でマッピングのマージを行う | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- デフォルトタイムアウト値（30s）はOpenSearchの一般的なデフォルト値であるが、当該ソースコード内で明示的に定義されている箇所を直接確認していない
  - 候補：`ClusterManagerNodeRequest.java` / `AckedRequest.java` / OpenSearch公式ドキュメント
- Security Pluginの権限名は別プラグインのコードに定義されているため、本プロジェクトのソースコード範囲外
  - 候補：`security` プラグイン / OpenSearch Security公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIパス、パラメータ仕様は REST API spec と Java ソースコードから直接確認済み
- 1: 中リスク - タイムアウトデフォルト値は一般的知識に基づく記述
- 0: 低リスク - マッピング更新の処理フローはソースコードから直接追跡可能

## 6) レビュアーチェックリスト（最小）
- [ ] デフォルトタイムアウト値（30s）が正しいか確認
- [ ] Security Pluginの権限名（indices:admin/mapping/put）が正しいか確認
- [ ] マッピング更新時の破壊的変更制限に関する記述が正確か確認
- [ ] expand_wildcards のデフォルト値が open であることを確認
