---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：52-フィールドマッピング取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **Security Plugin権限名**：具体的なアクション名の根拠がソースコード内にない

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_field_mapping.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetFieldMappingAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/TransportGetFieldMappingsAction.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは GET /_mapping/field/{fields} と GET /{index}/_mapping/field/{fields} | E-01, E-02 (行73) | ○ |
| C-02 | fieldsパラメータはlist型でカンマ区切り | E-01, E-02 (行84) | ○ |
| C-03 | include_defaultsパラメータが存在 | E-01, E-02 (行87) | ○ |
| C-04 | ignore_unavailableパラメータが存在 | E-01, E-02 (行88) | ○ |
| C-05 | expand_wildcardsのデフォルトはopen | E-01 | ○ |
| C-06 | localパラメータが存在し非推奨 | E-01, E-02 (行90-95) | ○ |
| C-07 | マッピングが空でフィールド指定時は404 | E-02 (行104-107) | ○ |
| C-08 | レスポンスにfull_nameとmappingが含まれる | E-02 (行102: FieldMappingMetadata) | ○ |
| C-09 | 関連機能はNo.17マッピング管理 | E-04 | ○ |
| C-10 | 参照系APIでデータ更新は発生しない | E-02 (GETメソッドのみ) | ○ |
| C-11 | RestBuilderListenerでレスポンスを構築 | E-02 (行99) | ○ |
| C-12 | 200または404ステータスを返却 | E-02 (行104-109) | ○ |
| C-13 | allow_no_indicesパラメータが存在 | E-01 | ○ |
| C-14 | Security Pluginで特定権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Security Pluginの権限名はセキュリティプラグインのコードに定義されているため、本プロジェクトのメインソースコード範囲外
  - 候補：`security` プラグイン / OpenSearch Security公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIパスとパラメータはREST API specとソースコードから確認済み
- 0: 低リスク - レスポンスステータスの分岐はソースコードから直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Security Pluginの権限名が正しいか確認
- [ ] レスポンスボディの構造が実際のAPIレスポンスと一致するか確認
- [ ] ワイルドカードによるフィールド指定が正しく動作するか確認
