---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：61-インデックステンプレート取得（レガシー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：セキュリティプラグインの権限モデルの具体的な根拠が不足
  2. **タイムアウトのデフォルト値**：cluster_manager_timeoutの30sデフォルト値の明示的な根拠要確認
  3. **レスポンスのversion項目**：versionフィールドの存在はコードから推測

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetIndexTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは GET /_template と GET /_template/{name} | E-01, E-02 | ○ |
| C-02 | HEADメソッドもサポートする | E-02（69行目） | ○ |
| C-03 | nameパラメータはカンマ区切りリストで複数指定可能 | E-01（type: list）, E-02（80行目） | ○ |
| C-04 | flat_settingsパラメータが存在する | E-01 | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在する | E-01 | ○ |
| C-06 | master_timeoutはv2.0.0で非推奨 | E-01（deprecated.version: 2.0.0） | ○ |
| C-07 | localパラメータが存在する | E-01 | ○ |
| C-08 | 名前未指定時は全テンプレートを返す（implicitAll） | E-02（89行目） | ○ |
| C-09 | テンプレート未存在時は404、implicitAll時は200 | E-02（95-97行目） | ○ |
| C-10 | 主機能は「インデックステンプレート」（機能No.7） | E-04（61行目） | ○ |
| C-11 | クラスタ状態からテンプレートメタデータを取得する | E-02（91-93行目） | ○ |
| C-12 | レスポンスにindex_patterns, settings, mappings, aliasesが含まれる | E-01（ドキュメントURL参照） | ○ |
| C-13 | レスポンスにorder, versionが含まれる | E-01（orderパラメータ参照） | ○ |
| C-14 | Composableテンプレートの使用が推奨される | E-01（documentation URL） | ○ |
| C-15 | セキュリティプラグインによる権限制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインにおけるインデックステンプレート読み取り権限の具体的なパーミッション名
  - 候補：SecurityPlugin / RestLayerAdditionalSecurityPlugin / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・パラメータ仕様 - REST API specから直接取得しており信頼性が高い
- 0: ステータスコード判定ロジック - ソースコードから直接確認済み
- 1: レスポンスボディの詳細フィールド - IndexTemplateMetadataのtoXContent実装の確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス・メソッドがREST API specと一致しているか
- [ ] パラメータ一覧が漏れなく記載されているか
- [ ] ステータスコードの判定条件がソースコードと一致しているか
- [ ] レスポンスボディのフィールドが実際のAPI出力と一致しているか
- [ ] 非推奨パラメータの記載が正しいか
