---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：62-インデックステンプレート作成（レガシー）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：セキュリティプラグインの具体的なパーミッション名が未確認
  2. **リクエストボディのバリデーション詳細**：index_patterns未指定時のエラー挙動の実装確認
  3. **create=trueのエラーステータスコード**：400か409かの実装確認

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.put_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestPutIndexTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは PUT/POST /_template/{name} | E-01, E-02 | ○ |
| C-02 | nameパラメータは必須のstring型 | E-01 | ○ |
| C-03 | orderパラメータで優先順位を指定可能 | E-01, E-02（85行目） | ○ |
| C-04 | createパラメータのデフォルトはfalse | E-01（default: false）, E-02（88行目） | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在する | E-01, E-02（86行目） | ○ |
| C-06 | master_timeoutはv2.0.0で非推奨 | E-01（deprecated.version: 2.0.0） | ○ |
| C-07 | リクエストボディは必須 | E-01（body.required: true） | ○ |
| C-08 | templateパラメータは非推奨でindex_patternsに置換 | E-02（76-81行目） | ○ |
| C-09 | リクエストボディをMapに変換しprepareMappingsで正規化 | E-02（91-93行目） | ○ |
| C-10 | レスポンスはacknowledged: trueを返す | E-02（RestToXContentListener使用） | ○ |
| C-11 | 主機能は「インデックステンプレート」（機能No.7） | E-04 | ○ |
| C-12 | index_patternsはリクエストボディで指定する | E-02（83行目） | ○ |
| C-13 | client.admin().indices().putTemplate()で実行 | E-02（95行目） | ○ |
| C-14 | MetadataIndexTemplateServiceでテンプレートを検証・保存 | E-02（間接的推論） | ○ |
| C-15 | causeパラメータでテンプレート作成理由を記録 | E-02（89行目） | ○ |
| C-16 | セキュリティプラグインによる権限制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインにおけるインデックステンプレート作成権限の具体的なパーミッション名
  - 候補：SecurityPlugin / 公式ドキュメント / RestLayerAdditionalSecurityPlugin

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・パラメータ仕様 - REST API specから直接取得しており信頼性が高い
- 0: 非推奨パラメータの処理 - ソースコードから直接確認済み
- 1: create=trueのエラー時ステータスコード - 正確なステータスコードの確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス・メソッドがREST API specと一致しているか
- [ ] リクエストボディの必須項目が正しく記載されているか
- [ ] createパラメータのエラー時挙動が正確か
- [ ] 非推奨パラメータ（template）の記載が正しいか
- [ ] マッピング正規化処理の説明が適切か
