---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：65-Composableインデックステンプレート取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスボディの詳細フィールド**：ComposableIndexTemplateのtoXContent()実装確認が望ましい
  2. **権限制御の詳細**：セキュリティプラグインの具体的な権限名が未確認
  3. **data_streamフィールド**：データストリーム設定の詳細構造の確認

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.get_index_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComposableIndexTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは GET /_index_template と GET /_index_template/{name} | E-01, E-02 | ○ |
| C-02 | HEADメソッドもサポートする | E-02（68行目） | ○ |
| C-03 | nameパラメータはカンマ区切りリストで複数指定可能 | E-01（type: list） | ○ |
| C-04 | flat_settingsパラメータが存在する | E-01 | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在する | E-01, E-02（82行目） | ○ |
| C-06 | master_timeoutはv2.0.0で非推奨 | E-01（deprecated.version: 2.0.0） | ○ |
| C-07 | localパラメータが存在する | E-01, E-02（81行目） | ○ |
| C-08 | 名前未指定時はimplicitAll=trueで全テンプレート返却 | E-02（85行目） | ○ |
| C-09 | テンプレート未存在時は404、implicitAll時は200 | E-02（92-94行目） | ○ |
| C-10 | 主機能は「インデックステンプレート」（機能No.7） | E-04 | ○ |
| C-11 | stability: experimentalで提供 | E-01（stability: experimental） | ○ |
| C-12 | GetComposableIndexTemplateAction.INSTANCEで実行 | E-02（88行目） | ○ |
| C-13 | レスポンスはindex_templates配列形式 | E-02（Response.indexTemplates()） | ○ |
| C-14 | composed_ofでコンポーネントテンプレートを参照 | E-02（間接参照、ComposableIndexTemplate構造） | ○ |
| C-15 | レスポンスにpriority, version, _meta等が含まれる | E-02（間接推論） | ○ |
| C-16 | セキュリティプラグインによる権限制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインにおけるComposableテンプレート読み取り権限の具体的なパーミッション名
  - 候補：SecurityPlugin / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・パラメータ仕様 - REST API specとソースコードから直接確認済み
- 0: ステータスコード判定ロジック - ソースコードから直接確認済み
- 1: レスポンスボディの詳細フィールド - ComposableIndexTemplate.toXContent()の実装確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス・メソッドがREST API specと一致しているか
- [ ] レスポンスボディのフィールド構造が正確か
- [ ] Composableテンプレート固有のフィールド（composed_of, priority等）が正しく記載されているか
- [ ] stability levelの記載が正しいか
