---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：69-コンポーネントテンプレート取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：セキュリティプラグインの具体的な権限名が未確認
  2. **レスポンスボディの詳細フィールド**：ComponentTemplate.toXContent()実装確認が望ましい
  3. **ワイルドカード対応の詳細**：nameパラメータのワイルドカードマッチングロジック確認

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.get_component_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComponentTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは GET /_component_template と GET /_component_template/{name} | E-01, E-02 | ○ |
| C-02 | HEADメソッドもサポートする | E-02（68行目） | ○ |
| C-03 | nameパラメータはカンマ区切りリストで複数指定可能 | E-01（type: list） | ○ |
| C-04 | cluster_manager_timeoutパラメータが存在する | E-01, E-02（83行目） | ○ |
| C-05 | master_timeoutはv2.0.0で非推奨 | E-01 | ○ |
| C-06 | localパラメータが存在する | E-01, E-02（82行目） | ○ |
| C-07 | 名前未指定時はimplicitAll=trueで全テンプレート返却 | E-02（86行目） | ○ |
| C-08 | テンプレート未存在時は404、implicitAll時は200 | E-02（93-95行目） | ○ |
| C-09 | 主機能は「インデックステンプレート」（機能No.7） | E-04 | ○ |
| C-10 | stability: experimentalで提供 | E-01 | ○ |
| C-11 | GetComponentTemplateAction.INSTANCEで実行 | E-02（89行目） | ○ |
| C-12 | レスポンスはcomponent_templates配列形式 | E-02（Response.getComponentTemplates()） | ○ |
| C-13 | コンポーネントテンプレートは単体でインデックスに適用されない | E-01（ドキュメントURL参照） | ○ |
| C-14 | Settings.FORMAT_PARAMSがresponseParamsに含まれる | E-02（101-103行目） | ○ |
| C-15 | セキュリティプラグインによる権限制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインにおけるコンポーネントテンプレート読み取り権限の具体名
  - 候補：SecurityPlugin / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・パラメータ仕様 - REST API specとソースコードから直接確認済み
- 0: ステータスコード判定ロジック - ソースコードから直接確認済み
- 1: レスポンスボディの詳細フィールド - ComponentTemplate.toXContent()の確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス・メソッドがREST API specと一致しているか
- [ ] レスポンスボディのフィールド構造が正確か
- [ ] コンポーネントテンプレートとComposableテンプレートの関係性の説明が正しいか
- [ ] HEADメソッドのサポートが正しく記載されているか
