---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 17
  claims_with_evidence: 16
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：70-コンポーネントテンプレート作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：16 / 17、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細**：セキュリティプラグインの具体的な権限名が未確認
  2. **参照元Composableテンプレートとの整合性チェック詳細**：MetadataIndexTemplateServiceの実装確認が望ましい
  3. **create=trueのエラーステータスコード**：正確なステータスコードの確認

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.put_component_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestPutComponentTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは PUT/POST /_component_template/{name} | E-01, E-02 | ○ |
| C-02 | nameパラメータは必須のstring型 | E-01 | ○ |
| C-03 | createパラメータのデフォルトはfalse | E-01, E-02（75行目） | ○ |
| C-04 | timeoutパラメータが存在する | E-01 | ○ |
| C-05 | cluster_manager_timeoutパラメータが存在する | E-01, E-02（73行目） | ○ |
| C-06 | master_timeoutはv2.0.0で非推奨 | E-01 | ○ |
| C-07 | リクエストボディは必須 | E-01（body.required: true） | ○ |
| C-08 | ComponentTemplate.parse()でボディをパース | E-02（77行目） | ○ |
| C-09 | PutComponentTemplateAction.INSTANCEで実行 | E-02（79行目） | ○ |
| C-10 | レスポンスはacknowledged: trueを返す | E-02（RestToXContentListener使用） | ○ |
| C-11 | 主機能は「インデックステンプレート」（機能No.7） | E-04 | ○ |
| C-12 | stability: experimentalで提供 | E-01 | ○ |
| C-13 | causeパラメータのデフォルト値は"api" | E-02（76行目） | ○ |
| C-14 | コンポーネントテンプレートにはindex_patternsがない | E-01（ドキュメントURL参照） | ○ |
| C-15 | 更新時に参照元Composableテンプレートとの整合性チェックが行われる | E-02（間接推論、MetadataIndexTemplateService） | ○ |
| C-16 | 既存インデックスには影響しない | E-01（ドキュメントURL参照） | ○ |
| C-17 | セキュリティプラグインによる権限制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティプラグインにおけるコンポーネントテンプレート作成権限の具体名
  - 候補：SecurityPlugin / 公式ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: APIパス・パラメータ仕様 - REST API specとソースコードから直接確認済み
- 0: ボディパース処理 - ソースコードから直接確認済み
- 1: 参照元テンプレートとの整合性チェック詳細 - MetadataIndexTemplateServiceのaddComponentTemplate()実装確認が望ましい
- 1: create=trueのエラー時ステータスコード - 正確なステータスコードの確認が望ましい

## 6) レビュアーチェックリスト（最小）
- [ ] APIパス・メソッドがREST API specと一致しているか
- [ ] リクエストボディの必須項目が正しく記載されているか
- [ ] createパラメータのエラー時挙動が正確か
- [ ] コンポーネントテンプレートの特性（index_patternsがない等）の記述が正しいか
- [ ] 参照元テンプレートとの整合性チェックの説明が適切か
