---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：71-コンポーネントテンプレート削除

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **テンプレート使用中時の挙動**：MetadataIndexTemplateServiceの詳細ロジック未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.delete_component_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDeleteComponentTemplateAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/template/delete/TransportDeleteComponentTemplateAction.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/indices/template/delete/DeleteComponentTemplateAction.java`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは DELETE /_component_template/{name} | E-01, E-02 | ○ |
| C-02 | nameパラメータはstring型で必須 | E-01 | ○ |
| C-03 | timeoutパラメータはtime型でオプション | E-01 | ○ |
| C-04 | cluster_manager_timeoutパラメータが存在 | E-01, E-02 | ○ |
| C-05 | master_timeoutはv2.0.0で非推奨 | E-01 | ○ |
| C-06 | stabilityはexperimental | E-01 | ○ |
| C-07 | RestDeleteComponentTemplateActionがエントリーポイント | E-02 | ○ |
| C-08 | prepareRequest()でDeleteComponentTemplateAction.Requestを生成 | E-02 | ○ |
| C-09 | TransportDeleteComponentTemplateActionがクラスタマネージャアクション | E-03 | ○ |
| C-10 | METADATA_WRITEレベルのクラスタブロックチェック | E-03 | ○ |
| C-11 | MetadataIndexTemplateService.removeComponentTemplate()を呼び出し | E-03 | ○ |
| C-12 | レスポンスはAcknowledgedResponse | E-03 | ○ |
| C-13 | 関連機能はインデックステンプレート（機能No.7） | E-06 | ○ |
| C-14 | 画面No.71、カテゴリはテンプレート管理 | E-05 | ○ |
| C-15 | テンプレート使用中の場合は削除拒否される可能性がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MetadataIndexTemplateService.removeComponentTemplate()の詳細ロジック（テンプレート参照チェック含む）は未精査
  - 候補：MetadataIndexTemplateService.java内のremoveComponentTemplateメソッド本体

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様・パラメータはREST API specから正確に抽出
- 0: 低リスク - ソースコードの処理フローは実コードに基づく
- 1: 中リスク - テンプレート参照時の削除拒否挙動は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] テンプレート使用中の削除時の具体的なエラーメッセージを確認
- [ ] 非推奨パラメータの実際のログ出力内容を確認
- [ ] クラスタブロック時のHTTPステータスコードを実環境で確認
