---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：72-コンポーネントテンプレート存在確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし。全ての主張に根拠が確認されている。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.exists_component_template.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestGetComponentTemplateAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは HEAD /_component_template/{name} | E-01, E-02 | ○ |
| C-02 | nameパラメータはstring型で必須 | E-01 | ○ |
| C-03 | master_timeoutパラメータが存在 | E-01 | ○ |
| C-04 | localパラメータがboolean型でデフォルトfalse | E-01 | ○ |
| C-05 | stabilityはexperimental | E-01 | ○ |
| C-06 | RestGetComponentTemplateActionがGET/HEAD共用ハンドラ | E-02 | ○ |
| C-07 | routes()でHEADメソッドが行68に定義 | E-02 | ○ |
| C-08 | テンプレートリストが空でなければ200 OK | E-02 | ○ |
| C-09 | テンプレートリストが空なら404 NOT_FOUND | E-02 | ○ |
| C-10 | localパラメータの処理が行82で実装 | E-02 | ○ |
| C-11 | cluster_manager_timeoutの処理が行83で実装 | E-02 | ○ |
| C-12 | 関連機能はインデックステンプレート（機能No.7） | E-04 | ○ |
| C-13 | 画面No.72、カテゴリはテンプレート管理 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードまたはAPI定義に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] HEADリクエスト時のレスポンスボディが確実に空であることを実環境で確認
- [ ] localパラメータ使用時のメタデータ鮮度に関する注意事項を運用観点で確認
