---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：78-データストリーム統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **レスポンスボディの詳細構造**：Response内のフィールド名は推測を含む
  2. **ブロードキャストアクションの挙動**：大規模クラスタでの性能特性

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.data_streams_stats.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestDataStreamsStatsAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 2つのGETルート（名前あり/なし）が存在 | E-01, E-02 | ○ |
| C-02 | nameパラメータはlist型でオプション | E-01 | ○ |
| C-03 | stabilityはexperimental | E-01 | ○ |
| C-04 | RestDataStreamsStatsActionがエントリーポイント | E-02 | ○ |
| C-05 | forbid_closed_indicesパラメータのデフォルトはtrue | E-02 | ○ |
| C-06 | デフォルトIndicesOptionsはstrictExpandOpenAndForbidClosed | E-02 | ○ |
| C-07 | IndicesOptions.fromRequest()を使用 | E-02 | ○ |
| C-08 | Strings.splitStringByCommaToArray()でname分割 | E-02 | ○ |
| C-09 | DataStreamsStatsAction.INSTANCEでTransport層に委譲 | E-02 | ○ |
| C-10 | 関連機能はデータストリーム（機能No.8）とインデックス統計（機能No.105） | E-04 | ○ |
| C-11 | 画面No.78、カテゴリはデータストリーム管理 | E-03 | ○ |
| C-12 | IndicesOptionsの設定が行69-75で実装 | E-02 | ○ |
| C-13 | アサーションが行73で実装 | E-02 | ○ |
| C-14 | レスポンスにdata_stream_count, backing_indices等が含まれる | **根拠なし** | △ |
| C-15 | ブロードキャストアクションとして各シャードに統計収集を実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスボディの正確な構造はDataStreamsStatsAction.Responseの実装を確認する必要がある
  - 候補：DataStreamsStatsAction.java内のResponseクラス
- ブロードキャストアクションの挙動はTransportActionの基底クラスを確認する必要がある

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様・IndicesOptions処理はソースコードから正確に抽出
- 1: 中リスク - レスポンスのフィールド名は推測を含む

## 6) レビュアーチェックリスト（最小）
- [ ] DataStreamsStatsAction.Responseの実際のJSON出力形式を確認
- [ ] forbid_closed_indicesパラメータの実際の効果を確認
- [ ] 大規模クラスタでの応答時間を確認
