---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-ドキュメントソース存在確認

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠が存在する。特に優先度の高いレビュー項目はない。

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/exists_source.json` - REST API仕様定義
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestGetSourceAction.java` - RESTハンドラ実装
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIパスは HEAD /{index}/_source/{id} | E-01, E-02 (70行目) | ○ |
| C-02 | ドキュメントソースの存在有無を確認する | E-01 | ○ |
| C-03 | RestGetSourceActionがGETとHEAD両方を処理する | E-02 (70行目) | ○ |
| C-04 | preferenceパラメータが存在する | E-01, E-02 (83行目) | ○ |
| C-05 | realtimeパラメータが存在する | E-01, E-02 (84行目) | ○ |
| C-06 | _source関連パラメータが存在する | E-01, E-02 (86行目) | ○ |
| C-07 | version/version_typeパラメータが存在する | E-01 | ○ |
| C-08 | checkResource()でドキュメント存在チェックを行う | E-02 (129行目) | ○ |
| C-09 | checkResource()でソース空チェックを行う | E-02 (131行目) | ○ |
| C-10 | ドキュメント未存在時にResourceNotFoundExceptionをスロー | E-02 (130行目) | ○ |
| C-11 | ソース空時にResourceNotFoundExceptionをスロー | E-02 (132行目) | ○ |
| C-12 | 関連機能No.11が主機能 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全ての主張がソースコードまたはAPI仕様から根拠付けされている。

## 5) リスクフラグ（レビュー観点）
- 0: 全ての主張が根拠付き

## 6) レビュアーチェックリスト（最小）
- [ ] HEADリクエスト時にResourceNotFoundExceptionが適切に404に変換されることを動作確認する
- [ ] ドキュメント存在確認API（HEAD /_doc）との動作の違いを確認する
