---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：81-同期フラッシュ（非推奨）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **同期フラッシュの非推奨経緯**：公式ドキュメントの確認が必要
  2. **権限名称の正確性**：OpenSearchセキュリティ設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.flush.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestFlushAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（81行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（114行目）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 同期フラッシュは非推奨APIである | E-03 | ○ |
| C-02 | indices.flush.jsonを通常フラッシュと共有している | E-01, E-03 | ○ |
| C-03 | POST/GETの2メソッドでアクセス可能 | E-01 | ○ |
| C-04 | forceパラメータが存在する | E-01 | ○ |
| C-05 | wait_if_ongoingパラメータが存在する | E-01 | ○ |
| C-06 | routes()で4つのルートを登録 | E-02（59-68行目） | ○ |
| C-07 | prepareRequest()でFlushRequestを構築 | E-02（76-82行目） | ○ |
| C-08 | 関連機能No.118フラッシュ | E-04 | ○ |
| C-09 | インデックス運用カテゴリに属する | E-03 | ○ |
| C-10 | expand_wildcardsのデフォルト値はopen | E-01 | ○ |
| C-11 | 同期フラッシュの機能が通常フラッシュに統合された経緯 | **根拠なし** | △ |
| C-12 | indices:admin/flush権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 同期フラッシュの非推奨化経緯に関する公式ドキュメントが未参照
  - 候補：OpenSearch公式ドキュメント / CHANGELOGファイル / GitHub Issue
- セキュリティ権限の正確な名称
  - 候補：SecurityPluginのソースコード / セキュリティ設定ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様定義との整合性は確認済み
- 1: 中リスク - 非推奨API固有の動作差異が存在する可能性
- 0: 低リスク - コードリーディングガイドのファイルパス・行番号は実コードと一致

## 6) レビュアーチェックリスト（最小）
- [ ] 同期フラッシュが実際に非推奨として扱われているか確認
- [ ] 通常フラッシュAPIとの動作差異が正しく記載されているか確認
- [ ] 権限名称が正しいか確認
