---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：82-強制マージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **ディスク使用量増加の注意事項**：運用ドキュメントの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.forcemerge.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestForceMergeAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（83行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（115行目）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | POSTメソッドのみ対応 | E-01 | ○ |
| C-02 | max_num_segmentsパラメータが存在する | E-01 | ○ |
| C-03 | only_expunge_deletesパラメータが存在する | E-01 | ○ |
| C-04 | flushパラメータのデフォルトはtrue | E-01 | ○ |
| C-05 | wait_for_completionパラメータが存在する | E-01 | ○ |
| C-06 | primary_onlyパラメータが存在する | E-01 | ○ |
| C-07 | 同期・非同期の分岐ロジックが86-95行目にある | E-02 | ○ |
| C-08 | only_expunge_deletesとmax_num_segmentsの同時指定で非推奨警告 | E-02（80-85行目） | ○ |
| C-09 | 非同期実行時にsetShouldStoreResult(true)が設定される | E-02（90行目） | ○ |
| C-10 | ForceMergeAction.INSTANCEで非同期実行される | E-02（93行目） | ○ |
| C-11 | routes()で2つのPOSTルートを登録 | E-02（64行目） | ○ |
| C-12 | 関連機能No.117フォースマージ | E-04 | ○ |
| C-13 | インデックス運用カテゴリに属する | E-03 | ○ |
| C-14 | expand_wildcardsのデフォルト値はopen | E-01 | ○ |
| C-15 | max_num_segments=1で完全統合時にディスク使用量が一時的に増加する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- マージ実行時のディスク使用量に関する具体的な数値・公式ドキュメント
  - 候補：OpenSearch公式ドキュメント / Luceneドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様定義との整合性は確認済み
- 0: 低リスク - ソースコードの行番号は実コードと一致確認済み
- 1: 中リスク - 運用上の注意事項（備考欄）は経験則に基づく記述

## 6) レビュアーチェックリスト（最小）
- [ ] 非同期実行時のタスクID返却形式が正しいか確認
- [ ] only_expunge_deletesとmax_num_segmentsの非推奨警告メッセージが正しいか確認
- [ ] primary_onlyパラメータの動作が正しく記載されているか確認
