---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：86-シャードストア情報

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスフィールドの正確な構造**：IndicesShardStoresResponseのtoXContent()確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.shard_stores.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesShardStoresAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（87行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（119行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GETメソッドのみ対応 | E-01 | ○ |
| C-02 | statusパラメータでgreen/yellow/red/allフィルタが可能 | E-01 | ○ |
| C-03 | routes()で2つのGETルートを登録（65行目） | E-02 | ○ |
| C-04 | allowSystemIndexAccessByDefault()がtrueを返す（74-76行目） | E-02 | ○ |
| C-05 | statusパラメータが存在する場合にshardStatuses()を設定（83-85行目） | E-02 | ○ |
| C-06 | RestBuilderListenerでカスタムレスポンス構築（89行目） | E-02 | ○ |
| C-07 | response.toXContent()でレスポンスを構築（93行目） | E-02 | ○ |
| C-08 | OKステータスで返却（95行目） | E-02 | ○ |
| C-09 | 関連機能No.56シャードアロケーション | E-04 | ○ |
| C-10 | インデックス運用カテゴリに属する | E-03 | ○ |
| C-11 | expand_wildcardsのデフォルト値はopen | E-01 | ○ |
| C-12 | ignore_unavailableパラメータが存在する | E-01 | ○ |
| C-13 | レスポンスフィールドの詳細構造（allocation_id, store_exception等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスフィールドの正確な構造
  - 候補：IndicesShardStoresResponse.java のtoXContent()メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様定義との整合性は確認済み
- 0: 低リスク - ソースコードの行番号は実コードと一致確認済み
- 0: 低リスク - RestBuilderListenerの使用パターンは実コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンスフィールドの構造がIndicesShardStoresResponse.toXContent()と一致するか確認
- [ ] statusパラメータ未指定時のデフォルト動作を確認
