---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：87-インデックス統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスフィールドの網羅性**：IndicesStatsResponseの構造確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/indices.stats.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/indices/RestIndicesStatsAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（88行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（120行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GETメソッドのみ対応 | E-01 | ○ |
| C-02 | 4つのパスパターンが存在する | E-01, E-02（67-76行目） | ○ |
| C-03 | metricにcompletion/docs/fielddata等の選択肢がある | E-01 | ○ |
| C-04 | levelパラメータでcluster/indices/shardsを指定可能 | E-01 | ○ |
| C-05 | levelのデフォルト値はindices | E-01 | ○ |
| C-06 | forbid_closed_indicesのデフォルト値はtrue | E-01 | ○ |
| C-07 | include_segment_file_sizesのデフォルト値はfalse | E-01 | ○ |
| C-08 | METRICSマップがCommonStatsFlags.Flag.values()から構築される（88-96行目） | E-02 | ○ |
| C-09 | _allと個別メトリクスの同時指定でIllegalArgumentException（116-123行目） | E-02 | ○ |
| C-10 | 無効メトリクス名でIllegalArgumentException（137-139行目） | E-02 | ○ |
| C-11 | canTripCircuitBreaker()がfalseを返す（167-169行目） | E-02 | ○ |
| C-12 | responseParams()にlevelが含まれる（171-176行目） | E-02 | ○ |
| C-13 | completion用サブフィールド設定（146-150行目） | E-02 | ○ |
| C-14 | fielddata用サブフィールド設定（152-156行目） | E-02 | ○ |
| C-15 | segments用サブフィールド設定（158-161行目） | E-02 | ○ |
| C-16 | 関連機能No.105インデックス統計 | E-04 | ○ |
| C-17 | インデックス運用カテゴリに属する | E-03 | ○ |
| C-18 | レスポンスフィールドの詳細構造（primaries, total, docs, store等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスフィールドの正確な構造
  - 候補：IndicesStatsResponse.java / CommonStats.java のtoXContent()メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様定義との整合性は確認済み
- 0: 低リスク - ソースコードの行番号は実コードと一致確認済み
- 0: 低リスク - METRICSマップの動的構築ロジックは実コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンスフィールドの構造がIndicesStatsResponseの実装と一致するか確認
- [ ] CommonStatsFlags.Flag列挙値が最新か確認（新規メトリクスの追加有無）
- [ ] forbid_closed_indicesの動作が正しく記載されているか確認
