---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：90-クラスタヘルス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスフィールドの網羅性**：ClusterHealthResponseの全フィールド確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.health.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterHealthAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（91行目）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（123-124行目）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GETメソッドのみ対応 | E-01 | ○ |
| C-02 | levelパラメータにcluster/indices/shards/awareness_attributesがある | E-01 | ○ |
| C-03 | levelのデフォルト値はcluster | E-01 | ○ |
| C-04 | expand_wildcardsのデフォルト値はall | E-01 | ○ |
| C-05 | wait_for_statusにgreen/yellow/redがある | E-01 | ○ |
| C-06 | wait_for_eventsにimmediate/urgent/high/normal/low/languidがある | E-01 | ○ |
| C-07 | master_timeoutは非推奨（version 2.0.0） | E-01 | ○ |
| C-08 | awareness_attributeパラメータが存在する | E-01 | ○ |
| C-09 | ensure_node_weighed_inパラメータが存在する | E-01 | ○ |
| C-10 | routes()で2つのGETルートを登録（69行目） | E-02 | ○ |
| C-11 | allowSystemIndexAccessByDefault()がtrueを返す（78-80行目） | E-02 | ○ |
| C-12 | fromRequest()で全パラメータを解析（88-134行目） | E-02 | ○ |
| C-13 | parseDeprecatedMasterTimeoutParameter()で非推奨警告（98行目） | E-02 | ○ |
| C-14 | setApplyLevelAtTransportLayer(true)が設定される（108行目） | E-02 | ○ |
| C-15 | wait_for_relocating_shardsが使用されるとIllegalArgumentException（119-124行目） | E-02 | ○ |
| C-16 | RestStatusToXContentListenerを使用（85行目） | E-02 | ○ |
| C-17 | canTripCircuitBreaker()がfalseを返す（144-146行目） | E-02 | ○ |
| C-18 | responseParams()にlevelが含まれる（136-141行目） | E-02 | ○ |
| C-19 | 関連機能No.47クラスタヘルスとNo.55 Awareness Health | E-04 | ○ |
| C-20 | クラスタ管理カテゴリに属する | E-03 | ○ |
| C-21 | 画面遷移図でクラスタ管理サブグラフに含まれる | E-05 | ○ |
| C-22 | レスポンスフィールドの詳細（cluster_name, status, number_of_nodes等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスフィールドの正確な構造
  - 候補：ClusterHealthResponse.java のtoXContent()メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API仕様定義との整合性は確認済み
- 0: 低リスク - ソースコードの行番号は実コードと一致確認済み
- 0: 低リスク - パラメータ解析ロジックは実コードで詳細確認済み
- 0: 低リスク - 非推奨パラメータの処理は実コードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] レスポンスフィールドの構造がClusterHealthResponse.toXContent()と一致するか確認
- [ ] awareness_attributes levelのレスポンス形式を確認
- [ ] RestStatusToXContentListenerによるHTTPステータスコードの動作を確認
- [ ] wait_for_*パラメータのタイムアウト時の動作を確認
