---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：95-アロケーション説明

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスフィールドの完全性**：node_allocation_decisionsの詳細構造はClusterAllocationExplanation.toXContent()に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.allocation_explain.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterAllocationExplainAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.95行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（No.95行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GET/POSTの2パターンのエンドポイント | E-01, E-02（行64-65） | ○ |
| C-02 | include_yes_decisionsパラメータ（デフォルトfalse） | E-01, E-02（行90） | ○ |
| C-03 | include_disk_infoパラメータ（デフォルトfalse） | E-01, E-02（行91） | ○ |
| C-04 | リクエストボディは任意 | E-01（body記述にrequiredなし） | ○ |
| C-05 | ボディなしで最初の未割り当てシャードを説明 | E-01（body.description）, E-02（行82-83） | ○ |
| C-06 | ボディありでClusterAllocationExplainRequest.parseを使用 | E-02（行85-87） | ○ |
| C-07 | allowSystemIndexAccessByDefaultがtrue | E-02（行74-76） | ○ |
| C-08 | 関連機能はNo.56 シャードアロケーション | E-04 | ○ |
| C-09 | RestBuilderListenerでレスポンス構築 | E-02（行94） | ○ |
| C-10 | getExplanation().toXContent()でシリアライズ | E-02（行97） | ○ |
| C-11 | リクエストボディにindex, shard, primaryフィールド | E-01（body.description） | ○ |
| C-12 | レスポンスステータスは200 OK | E-02（行98, RestStatus.OK） | ○ |
| C-13 | レスポンスの詳細フィールド構成（node_allocation_decisions等） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスの詳細フィールド構成はClusterAllocationExplanation.toXContent()の実装を追跡する必要がある。
  - 候補：`ClusterAllocationExplanation.java` のtoXContentメソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIパスおよびパラメータ仕様
- 0: 低リスク - リクエストボディの構造
- 1: 中リスク - レスポンスフィールドの完全性

## 6) レビュアーチェックリスト（最小）
- [ ] GET/POSTの両メソッドが正しいか
- [ ] リクエストボディの任意性が正しいか
- [ ] ボディなし時の挙動が正しいか
- [ ] レスポンスフィールドに不足がないか
