---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：96-クラスタ再ルーティング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **コマンド種別の完全性**：allocate_stale_primary, allocate_empty_primaryの存在はAllocationCommands実装に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.reroute.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestClusterRerouteAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.96行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（No.96行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは POST /_cluster/reroute | E-01, E-02（行95） | ○ |
| C-02 | dry_runパラメータが存在 | E-01, E-02（行147） | ○ |
| C-03 | explainパラメータが存在 | E-01, E-02（行148） | ○ |
| C-04 | retry_failedパラメータが存在 | E-01, E-02（行150） | ○ |
| C-05 | metricパラメータの選択肢 | E-01（params.metric.options） | ○ |
| C-06 | metricのデフォルトはメタデータ以外の全て | E-02（行77-79, 116-118） | ○ |
| C-07 | cluster_manager_timeoutパラメータが存在 | E-01, E-02（行151-153） | ○ |
| C-08 | master_timeoutはv2.0.0で非推奨 | E-01（deprecated.version） | ○ |
| C-09 | ObjectParserでcommands配列を解析 | E-02（行67-75） | ○ |
| C-10 | SettingsFilterの適用 | E-02（行111） | ○ |
| C-11 | master_nodeメトリクスの非推奨ログ出力 | E-02（行89-91, 124-126） | ○ |
| C-12 | allowSystemIndexAccessByDefaultがtrue | E-02（行104-106） | ○ |
| C-13 | 関連機能はNo.56 シャードアロケーション | E-04 | ○ |
| C-14 | RestToXContentListenerでレスポンス構築 | E-02（行128） | ○ |
| C-15 | リクエストボディでdry_runも指定可能 | E-02（行74） | ○ |
| C-16 | 全コマンド種別（move, cancel, allocate_replica, allocate_stale_primary, allocate_empty_primary） | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- コマンド種別の完全なリストはAllocationCommands.fromXContent()の実装と、登録されたAllocationCommand実装クラスを確認する必要がある。
  - 候補：`AllocationCommands.java` / `MoveAllocationCommand.java` / `CancelAllocationCommand.java` 等

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIパスおよびパラメータ仕様
- 0: 低リスク - metricのデフォルト値（ソースコードで直接確認）
- 1: 中リスク - コマンド種別の完全性

## 6) レビュアーチェックリスト（最小）
- [ ] APIエンドポイントが正しいか
- [ ] 全コマンド種別が網羅されているか
- [ ] dry_runの挙動が正しく記述されているか
- [ ] metricのデフォルト値が正しいか
