---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 11
  claims_with_evidence: 10
  claims_without_evidence: 1
confidence_derived: 0.91
---

# 根拠レポート：97-保留中タスク

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：10 / 11、根拠なし：1
- 優先レビュー（高）
  1. **レスポンスフィールドの完全性**：tasks配列の詳細フィールドはPendingClusterTasksResponse.toXContent()に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/cluster.pending_tasks.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/admin/cluster/RestPendingClusterTasksAction.java`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.97行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（No.97行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは GET /_cluster/pending_tasks | E-01, E-02（行59） | ○ |
| C-02 | localパラメータ（デフォルトfalse） | E-01, E-02（行74） | ○ |
| C-03 | cluster_manager_timeoutパラメータが存在 | E-01, E-02（行70-71） | ○ |
| C-04 | master_timeoutはv2.0.0で非推奨 | E-01（deprecated.version） | ○ |
| C-05 | master_timeout非推奨パラメータの処理 | E-02（行55, 73） | ○ |
| C-06 | RestToXContentListenerでレスポンス構築 | E-02（行75） | ○ |
| C-07 | PendingClusterTasksRequestを構築 | E-02（行69） | ○ |
| C-08 | 関連機能はNo.51 タスク管理 | E-04 | ○ |
| C-09 | client.admin().cluster().pendingClusterTasks()で実行 | E-02（行75） | ○ |
| C-10 | 画面名は「保留中タスク」 | E-03 | ○ |
| C-11 | レスポンスのtasks配列の詳細フィールド構成 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- レスポンスのtasks配列内の各フィールド（insert_order, priority, source, time_in_queue等）はPendingClusterTasksResponseのtoXContent実装で確認する必要がある。
  - 候補：`PendingClusterTasksResponse.java` / `PendingClusterTask.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - APIパスおよびパラメータ仕様
- 1: 中リスク - レスポンスフィールドの完全性

## 6) レビュアーチェックリスト（最小）
- [ ] APIエンドポイントが正しいか
- [ ] パラメータのデフォルト値が正しいか
- [ ] タスクの優先度レベルが正しいか
- [ ] レスポンスフィールドに不足がないか
