# 通知設計書 1-ClusterStateListener通知

## 概要

本ドキュメントは、OpenSearchにおけるClusterStateListener通知の設計仕様を記載する。ClusterStateListenerはクラスタ状態の変化を各コンポーネントに通知するための中核的なリスナーインターフェースであり、ノードの追加・削除、インデックスの作成・変更・削除、シャードの再配置など、あらゆるクラスタ状態変化を包含するイベント駆動型の通知メカニズムである。

### 本通知の処理概要

ClusterStateListener通知は、OpenSearchクラスタ内でクラスタ状態（ClusterState）が変化するたびに、登録されたすべてのリスナーに対してClusterChangedEventを配信する仕組みである。

**業務上の目的・背景**：OpenSearchは分散システムであり、クラスタを構成するノード群が協調して動作するために、クラスタ状態の一貫した伝搬が不可欠である。クラスタマネージャーノードがクラスタ状態を更新した際に、各データノード・コーディネートノードがその変化を検知し、インデックスのルーティングテーブル更新、シャードの割り当て変更、メタデータの同期などの後続処理を実行する必要がある。ClusterStateListenerはこの基盤を提供する。

**通知の送信タイミング**：クラスタマネージャーがクラスタ状態を更新し、新しいClusterStateが各ノードのClusterApplierServiceで適用された直後に通知が発火する。具体的には、ClusterApplierService#callClusterStateListeners()メソッド内で、登録されたすべてのClusterStateListenerのclusterChanged()メソッドが順次呼び出される。

**通知の受信者**：ClusterStateListenerインターフェースを実装し、ClusterApplierServiceまたはClusterServiceに登録したすべてのコンポーネントが受信者となる。代表的な受信者にはGatewayService、IndicesClusterStateService、SnapshotsService、PersistentTasksNodeServiceなどがある。

**通知内容の概要**：ClusterChangedEventオブジェクトが通知内容の本体であり、変更前のClusterState（previousState）、変更後のClusterState（state）、変更元の識別子（source）、ノードの差分（nodesDelta）を含む。受信者はこれらの情報から、インデックスの追加・削除、ノードの追加・離脱、メタデータの変更、ルーティングテーブルの変化などを判定できる。

**期待されるアクション**：受信者は通知を受け取った後、自身の担当領域に関連する変更の有無を判定し、必要に応じてインデックスの作成・削除、シャードのリカバリ開始、ルーティング情報の更新、設定の反映などの処理を実行する。処理はクラスタ適用スレッド上で同期的に実行されるため、長時間のブロッキング処理は避ける必要がある。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるリスナーパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（クラスタ適用スレッド上で順次実行） |
| 優先度 | 高（クラスタ状態変更の伝搬は最優先処理） |
| リトライ | 無し（例外発生時は警告ログを出力して次のリスナーの処理を継続） |

### 送信先決定ロジック

ClusterApplierServiceが内部で保持するCopyOnWriteArrayList<ClusterStateListener>（clusterStateListeners）に登録されたすべてのリスナーに対して順次通知する。登録はaddListener()メソッド、解除はremoveListener()メソッドで行う。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaオブジェクト ClusterChangedEvent として通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| event.source | クラスタ状態変更の発生元識別子 | ClusterChangedEvent#source() | Yes |
| event.state | 変更後のクラスタ状態 | ClusterChangedEvent#state() | Yes |
| event.previousState | 変更前のクラスタ状態 | ClusterChangedEvent#previousState() | Yes |
| event.nodesDelta | ノードの追加・削除差分 | ClusterChangedEvent内部のDiscoveryNodes.Delta | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| クラスタ状態更新 | クラスタマネージャーによるClusterState更新 | 新しいClusterStateが適用されること | ノード参加・離脱、インデックスCRUD、シャード割り当て変更等すべてのクラスタ状態変化が対象 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ClusterApplierServiceが停止中 | ライフサイクルが停止状態の場合はリスナー通知を行わない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クラスタマネージャーがClusterState更新] --> B[ClusterApplierService#applyChanges]
    B --> C[ClusterStateAppliersの実行]
    C --> D[callClusterStateListeners呼び出し]
    D --> E[clusterStateListenersの各リスナーを順次呼び出し]
    E --> F[timeoutClusterStateListenersの各リスナーを順次呼び出し]
    F --> G{例外発生?}
    G -->|Yes| H[警告ログ出力し次のリスナーへ]
    G -->|No| I[次のリスナーへ]
    H --> J[全リスナー処理完了]
    I --> J
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない。ClusterStateはインメモリおよびクラスタメタデータとして管理される |

### テーブル別参照項目詳細

N/A（データベーステーブルは使用しない）

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | ログはLog4j経由でファイル出力 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー実行時例外 | clusterChanged()内で例外がスローされた場合 | 警告ログ（"failed to notify ClusterStateListener"）を出力し、後続リスナーの処理を継続 |
| クラスタ適用スレッド停止 | ClusterApplierServiceが停止済みの場合 | 通知自体が実行されない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（クラスタ状態変更の都度発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（24時間365日、クラスタ状態変更の都度通知）

## セキュリティ考慮事項

ClusterStateにはクラスタ全体のメタデータが含まれるため、リスナー実装側で機密情報の取り扱いに注意が必要。ClusterStateListener自体はプロセス内通知のため、ネットワーク上のセキュリティリスクは限定的である。@PublicApi(since = "1.0.0")としてマークされているため、プラグインからも利用可能。

## 備考

- ClusterStateListenerは@PublicApi(since = "1.0.0")として公開APIに指定されている
- ClusterApplierServiceはリスナー実行時間を計測し、メトリクス（clusterStateListenersHistogram）に記録する
- slow_task_logging_thresholdを超えた場合は低速処理として警告ログが出力される
- TimeoutClusterStateListenerもClusterStateListenerを拡張しており、同じ通知パスで呼び出される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、通知で受け渡されるデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterStateListener.java | `server/src/main/java/org/opensearch/cluster/ClusterStateListener.java` | clusterChanged(ClusterChangedEvent)メソッドの定義を確認（行48） |
| 1-2 | ClusterChangedEvent.java | `server/src/main/java/org/opensearch/cluster/ClusterChangedEvent.java` | source, state, previousState, nodesDeltaの4つのフィールドとコンストラクタ（行59-77） |

**読解のコツ**: ClusterStateListenerはFunctional Interfaceに近いシンプルなインターフェースであり、clusterChanged()メソッド1つのみを定義している。

#### Step 2: エントリーポイントを理解する

処理の起点となるClusterApplierServiceを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClusterApplierService.java | `server/src/main/java/org/opensearch/cluster/service/ClusterApplierService.java` | clusterStateListenersフィールド（行120）、addListener/removeListener（行290-298）、callClusterStateListeners（行670-696） |

**主要処理フロー**:
1. **行120**: `CopyOnWriteArrayList<ClusterStateListener>`でリスナーリストを管理
2. **行290-291**: `addListener()`でリスナーを登録
3. **行615**: `callClusterStateListeners(clusterChangedEvent, stopWatch)`で通知開始
4. **行670-672**: clusterStateListenersとtimeoutClusterStateListenersの両方を順次呼び出し
5. **行680-695**: 各リスナーのclusterChanged()を呼び出し、例外時は警告ログを出力して継続

#### Step 3: ClusterServiceを理解する

ClusterApplierServiceを利用する上位サービスを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ClusterService.java | `server/src/main/java/org/opensearch/cluster/service/ClusterService.java` | ClusterApplierServiceへの委譲メソッドを確認 |

**主要処理フロー**:
- ClusterService#addListener()がClusterApplierService#addListener()に委譲する

### プログラム呼び出し階層図

```
ClusterManager (クラスタ状態更新)
    |
    +-- ClusterApplierService#applyChanges()
            |
            +-- callClusterStateAppliers()  [Appliers実行]
            |
            +-- callClusterStateListeners() [行670]
                    |
                    +-- callClusterStateListener(clusterStateListeners) [行671]
                    |       |
                    |       +-- listener.clusterChanged(event) [行685]
                    |
                    +-- callClusterStateListener(timeoutClusterStateListeners) [行672]
                            |
                            +-- listener.clusterChanged(event)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ClusterState(new)  ───+
                      |──▶ ClusterChangedEvent生成 ───▶ ClusterApplierService ───▶ listener.clusterChanged(event)
ClusterState(old)  ───+                                      |
                                                             +───▶ メトリクス記録
                                                             +───▶ ログ出力（低速時）
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClusterStateListener.java | `server/src/main/java/org/opensearch/cluster/ClusterStateListener.java` | ソース | リスナーインターフェース定義 |
| ClusterChangedEvent.java | `server/src/main/java/org/opensearch/cluster/ClusterChangedEvent.java` | ソース | 通知イベントデータ構造 |
| ClusterApplierService.java | `server/src/main/java/org/opensearch/cluster/service/ClusterApplierService.java` | ソース | リスナー管理と通知実行 |
| ClusterService.java | `server/src/main/java/org/opensearch/cluster/service/ClusterService.java` | ソース | 上位サービス（リスナー登録の委譲） |
| ClusterState.java | `server/src/main/java/org/opensearch/cluster/ClusterState.java` | ソース | クラスタ状態データ構造 |
