# 通知設計書 10-SearchProgressListener通知

## 概要

本ドキュメントは、OpenSearchにおけるSearchProgressListener通知の設計仕様を記載する。SearchProgressListenerは検索処理の進捗（シャード一覧・クエリ結果・フェッチ結果・部分集約結果・失敗）をリスナーに通知するための抽象クラスである。

### 本通知の処理概要

SearchProgressListener通知は、SearchAction（検索リクエスト）の処理進捗をリアルタイムに追跡するための仕組みである。

**業務上の目的・背景**：OpenSearchの検索処理は複数のシャードに対して並行に実行され、クエリフェーズ、集約フェーズ、フェッチフェーズと段階的に進行する。検索の進捗状況をリアルタイムに追跡することで、長時間検索の監視、進捗ベースのUI更新、検索パフォーマンスの分析が可能になる。SearchTaskに紐づけられ、検索処理の各段階で進捗を通知する。

**通知の送信タイミング**：検索処理の各フェーズで通知が発生する。(1) シャード一覧が確定した時にonListShards()が呼ばれる。(2) 各シャードからクエリ結果が返った時にonQueryResult()が呼ばれる。(3) クエリ失敗時にonQueryFailure()が呼ばれる。(4) 部分集約が完了した時にonPartialReduce()が呼ばれる。(5) 最終集約が完了した時にonFinalReduce()が呼ばれる。(6) 各シャードからフェッチ結果が返った時にonFetchResult()が呼ばれる。(7) フェッチ失敗時にonFetchFailure()が呼ばれる。

**通知の受信者**：SearchProgressListenerを継承したクラス。SearchTaskのprogressListenerフィールドに設定される。SearchProgressActionListenerはSearchProgressListenerとActionListenerの両方を実装する抽象クラスである。

**通知内容の概要**：onListShards()ではシャードリスト、スキップシャードリスト、クラスタ統計、フェッチフェーズ有無が渡される。onQueryResult/onFetchResultではシャードインデックスが渡される。onQueryFailure/onFetchFailureではシャードインデックス、SearchShardTarget、例外が渡される。onPartialReduce/onFinalReduceではシャードリスト、TotalHits、集約結果、reducePhaseバージョンが渡される。

**期待されるアクション**：受信者は検索進捗を追跡し、UI更新、ログ記録、パフォーマンス分析などに活用する。コールバック内で例外が発生した場合は警告ログが出力され、検索処理自体には影響しない。

## 通知種別

プロセス内コールバック通知（Java抽象クラスのオーバーライドによるリスナーパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（検索処理スレッド上で実行） |
| 優先度 | 中（進捗追跡であり検索結果には影響しない） |
| リトライ | 無し |

### 送信先決定ロジック

SearchTaskのprogressListenerフィールドに設定されたSearchProgressListenerに対して通知する。デフォルトはSearchProgressListener.NOOP（何もしない実装）。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaメソッドコールバックとして通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| shards | 検索対象シャードリスト | SearchShard | onListShards時 |
| skippedShards | スキップされたシャードリスト | SearchShard | onListShards時 |
| clusters | リモートクラスタ統計 | SearchResponse.Clusters | onListShards時 |
| fetchPhase | フェッチフェーズの有無 | boolean | onListShards時 |
| shardIndex | シャードのインデックス（onListShardsで返されたリスト内の位置） | int | onQueryResult/onFetchResult時 |
| shardTarget | 失敗したシャードの情報 | SearchShardTarget | onQueryFailure/onFetchFailure時 |
| exc | 失敗の例外 | Exception | onQueryFailure/onFetchFailure時 |
| totalHits | ヒット総数 | TotalHits | onPartialReduce/onFinalReduce時 |
| aggs | 集約結果 | InternalAggregations | onPartialReduce/onFinalReduce時 |
| reducePhase | reduceフェーズのバージョン番号 | int | onPartialReduce/onFinalReduce時 |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| シャード一覧確定 | 検索対象シャードの決定 | 検索開始時 | onListShards(shards, skippedShards, clusters, fetchPhase) |
| クエリ結果 | シャードからのクエリ結果受信 | クエリフェーズ完了 | onQueryResult(shardIndex) |
| クエリ失敗 | シャードのクエリ失敗 | クエリフェーズで例外発生 | onQueryFailure(shardIndex, shardTarget, exc) |
| 部分集約 | バッチ集約の実行 | batchedReduceSizeに達した場合 | onPartialReduce(shards, totalHits, aggs, reducePhase) |
| 最終集約 | 全シャードの集約完了 | 全クエリ結果の集約完了時 | onFinalReduce(shards, totalHits, aggs, reducePhase) |
| フェッチ結果 | シャードからのフェッチ結果受信 | フェッチフェーズ完了 | onFetchResult(shardIndex) |
| フェッチ失敗 | シャードのフェッチ失敗 | フェッチフェーズで例外発生 | onFetchFailure(shardIndex, shardTarget, exc) |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| NOOP設定時 | SearchProgressListener.NOOPがデフォルトで設定されており、何もしない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[検索リクエスト受信] --> B[SearchTask生成]
    B --> C[シャード一覧確定]
    C --> D[notifyListShards]
    D --> E[クエリフェーズ開始]
    E --> F{各シャードの結果}
    F -->|成功| G[notifyQueryResult]
    F -->|失敗| H[notifyQueryFailure]
    G --> I{バッチサイズ到達?}
    I -->|Yes| J[notifyPartialReduce]
    I -->|No| K[次のシャードへ]
    J --> K
    H --> K
    K --> L{全シャード完了?}
    L -->|No| F
    L -->|Yes| M[notifyFinalReduce]
    M --> N[フェッチフェーズ]
    N --> O{各シャードのフェッチ}
    O -->|成功| P[notifyFetchResult]
    O -->|失敗| Q[notifyFetchFailure]
    P --> R[検索完了]
    Q --> R
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

### テーブル別参照項目詳細

N/A

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | N/A |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー実行時例外 | コールバック内で例外がスローされた場合 | 警告ログ（"Failed to execute progress listener on ..."）を出力して検索処理は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（検索処理の進捗に応じて発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

検索結果データ（集約結果、ヒット数等）がリスナーに渡される。@PublicApi(since = "1.0.0")としてマークされており、プラグインからも利用可能。

## 備考

- @PublicApi(since = "1.0.0")として公開APIに指定されている
- 抽象クラスであり、各コールバックはprotectedメソッドとしてデフォルト空実装を持つ
- NOOP静的フィールドが空の実装として提供されている
- SearchTaskのprogressListenerフィールドに設定（デフォルトはNOOP）
- notifyXxx()メソッド群はfinalメソッドで、例外をキャッチして警告ログを出力するラッパーとして機能
- SearchProgressActionListenerはSearchProgressListenerとActionListenerの両方を実装する便利な抽象クラス
- buildSearchShards()ユーティリティメソッドでSearchPhaseResultリストやGroupShardsIteratorからSearchShardリストを生成可能
- onPartialReduceの呼び出し頻度はSearchRequest#setBatchedReduceSize()で制御可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SearchProgressListener.java | `server/src/main/java/org/opensearch/action/search/SearchProgressListener.java` | 7つのprotectedコールバック定義（行74, 81, 90, 101, 111, 118, 127）とNOOP定義（行61-62） |
| 1-2 | SearchShard.java | `server/src/main/java/org/opensearch/action/search/SearchShard.java` | シャード識別データ構造 |

**読解のコツ**: protectedコールバック（onXxx）とfinal通知メソッド（notifyXxx）を区別する。protectedメソッドはサブクラスがオーバーライドする。finalメソッドは内部から呼ばれ、例外ハンドリングを行うラッパーである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SearchTask.java | `server/src/main/java/org/opensearch/action/search/SearchTask.java` | progressListenerフィールド（行55）とデフォルトNOOP設定 |
| 2-2 | SearchProgressActionListener.java | `server/src/main/java/org/opensearch/action/search/SearchProgressActionListener.java` | SearchProgressListener + ActionListenerの複合抽象クラス（行43） |

**主要処理フロー**:
1. **SearchTask行55**: `SearchProgressListener progressListener = SearchProgressListener.NOOP` - デフォルトNOOP
2. **SearchProgressListener行129-136**: `notifyListShards()` - shardsフィールドを設定しonListShards()を呼ぶ
3. **SearchProgressListener行138-147**: `notifyQueryResult()` - onQueryResult()を呼ぶ
4. **SearchProgressListener行160-166**: `notifyPartialReduce()` - onPartialReduce()を呼ぶ
5. **SearchProgressListener行168-174**: `notifyFinalReduce()` - onFinalReduce()を呼ぶ
6. **SearchProgressListener行176-185**: `notifyFetchResult()` - onFetchResult()を呼ぶ

#### Step 3: 検索処理からの呼び出しを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SearchQueryThenFetchAsyncAction.java | `server/src/main/java/org/opensearch/action/search/SearchQueryThenFetchAsyncAction.java` | クエリフェーズでのnotifyQueryResult/Failure呼び出し |
| 3-2 | FetchSearchPhase.java | `server/src/main/java/org/opensearch/action/search/FetchSearchPhase.java` | フェッチフェーズでのnotifyFetchResult/Failure呼び出し |
| 3-3 | QueryPhaseResultConsumer.java | `server/src/main/java/org/opensearch/action/search/QueryPhaseResultConsumer.java` | 集約フェーズでのnotifyPartialReduce/FinalReduce呼び出し |

### プログラム呼び出し階層図

```
SearchAction実行
    |
    +-- SearchTask生成（progressListener設定）
    |
    +-- SearchQueryThenFetchAsyncAction
            |
            +-- notifyListShards(shards, skipped, clusters, fetchPhase)
            |       +-- onListShards()  [protected, 行74]
            |
            +-- [各シャードクエリ]
            |       +-- notifyQueryResult(shardIndex)  [行138]
            |       |       +-- onQueryResult()  [protected, 行81]
            |       +-- notifyQueryFailure(shardIndex, target, exc)  [行149]
            |               +-- onQueryFailure()  [protected, 行90]
            |
            +-- QueryPhaseResultConsumer
            |       +-- notifyPartialReduce(shards, totalHits, aggs, phase)  [行160]
            |       |       +-- onPartialReduce()  [protected, 行101]
            |       +-- notifyFinalReduce(shards, totalHits, aggs, phase)  [行168]
            |               +-- onFinalReduce()  [protected, 行111]
            |
            +-- FetchSearchPhase
                    +-- notifyFetchResult(shardIndex)  [行176]
                    |       +-- onFetchResult()  [protected, 行118]
                    +-- notifyFetchFailure(shardIndex, target, exc)  [行187]
                            +-- onFetchFailure()  [protected, 行127]
```

### データフロー図

```
[入力]                            [処理]                               [出力]

検索リクエスト      ───▶ SearchTask(progressListener)
                              |
シャード一覧        ───▶ notifyListShards()        ───▶ onListShards(shards, skipped, clusters, fetchPhase)
クエリ結果          ───▶ notifyQueryResult()       ───▶ onQueryResult(shardIndex)
クエリ失敗          ───▶ notifyQueryFailure()      ───▶ onQueryFailure(shardIndex, target, exc)
部分集約結果        ───▶ notifyPartialReduce()     ───▶ onPartialReduce(shards, totalHits, aggs, phase)
最終集約結果        ───▶ notifyFinalReduce()       ───▶ onFinalReduce(shards, totalHits, aggs, phase)
フェッチ結果        ───▶ notifyFetchResult()       ───▶ onFetchResult(shardIndex)
フェッチ失敗        ───▶ notifyFetchFailure()      ───▶ onFetchFailure(shardIndex, target, exc)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SearchProgressListener.java | `server/src/main/java/org/opensearch/action/search/SearchProgressListener.java` | ソース | 進捗リスナー抽象クラス |
| SearchProgressActionListener.java | `server/src/main/java/org/opensearch/action/search/SearchProgressActionListener.java` | ソース | ActionListenerとの複合抽象クラス |
| SearchTask.java | `server/src/main/java/org/opensearch/action/search/SearchTask.java` | ソース | progressListenerフィールド保持 |
| SearchShard.java | `server/src/main/java/org/opensearch/action/search/SearchShard.java` | ソース | シャード識別データ構造 |
| SearchQueryThenFetchAsyncAction.java | `server/src/main/java/org/opensearch/action/search/SearchQueryThenFetchAsyncAction.java` | ソース | クエリフェーズからの通知呼び出し |
| FetchSearchPhase.java | `server/src/main/java/org/opensearch/action/search/FetchSearchPhase.java` | ソース | フェッチフェーズからの通知呼び出し |
| QueryPhaseResultConsumer.java | `server/src/main/java/org/opensearch/action/search/QueryPhaseResultConsumer.java` | ソース | 集約フェーズからの通知呼び出し |
