# 通知設計書 11-EarlyTerminatingListener通知

## 概要

本ドキュメントは、OpenSearchの並列セグメント検索（Concurrent Segment Search）において、早期終了（Early Termination）の意図をスライス間で伝播するためのEarlyTerminatingListener通知の設計を記述する。

### 本通知の処理概要

EarlyTerminatingListenerは、並列セグメント検索中にあるスライスで早期終了が発生した際に、その情報を他のCollectorManagerに伝播するためのインターフェースである。

**業務上の目的・背景**：OpenSearchでは検索パフォーマンスを向上させるため、複数のセグメントを並列に検索する機能（Concurrent Segment Search）を提供している。検索クエリにterminate_afterパラメータが指定された場合や、十分な結果が得られた場合に早期終了を行うが、並列実行中の他のスライスにもこの情報を伝える必要がある。EarlyTerminatingListenerはこの伝播メカニズムを提供する。

**通知の送信タイミング**：EarlyTerminatingCollectorManagerのreduce()メソッド実行時に、いずれかのEarlyTerminatingCollectorがhasEarlyTerminated()でtrueを返した場合に、onEarlyTermination()コールバックが呼び出される。

**通知の受信者**：EarlyTerminatingListenerインターフェースを実装するCollectorManager（例：TotalHitCountCollectorManager）が受信者となる。内部のCollectorManagerチェーンに沿って伝播される。

**通知内容の概要**：maxCountHits（目標とする最大ヒット数）とforcedTermination（強制終了かどうかのブーリアン値）の2つのパラメータが通知される。

**期待されるアクション**：受信者はmaxCountHitsの値を記録し、reduce時にTotalHitsのリレーション（GREATER_THAN_OR_EQUAL_TO）を適切に設定することで、検索結果が早期終了により不完全であることを利用者に伝える。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（reduce処理内での直接呼び出し） |
| 優先度 | 高（検索結果の正確性に影響） |
| リトライ | なし（同期呼び出しのため不要） |

### 送信先決定ロジック

EarlyTerminatingCollectorManagerがラップする内部CollectorManagerがEarlyTerminatingListenerインターフェースを実装しているかをinstanceof演算子で判定し、実装している場合のみonEarlyTermination()を呼び出す（EarlyTerminatingCollectorManager.java 75行目）。

## 通知テンプレート

### メール通知の場合

該当なし（プロセス内コールバック通知のため、メール等の外部通知は行わない）。

### 本文テンプレート

```
該当なし（Javaメソッドの引数としてパラメータが渡される）
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| maxCountHits | 早期終了の目標ヒット数 | EarlyTerminatingCollectorManagerのコンストラクタ引数 | Yes |
| forcedTermination | 強制終了フラグ | EarlyTerminatingCollectorManagerのコンストラクタ引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 検索処理 | EarlyTerminatingCollectorManager.reduce()実行 | いずれかのEarlyTerminatingCollectorがhasEarlyTerminated()でtrueを返す | 並列検索のreduce段階で早期終了を検出した場合に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 早期終了未発生 | どのCollectorもhasEarlyTerminated()がfalseの場合、通知は行われない |
| リスナー未実装 | 内部CollectorManagerがEarlyTerminatingListenerを実装していない場合、通知は伝播されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[並列セグメント検索実行] --> B[各スライスでCollector実行]
    B --> C[EarlyTerminatingCollectorManager.reduce実行]
    C --> D{いずれかのCollectorが早期終了?}
    D -->|Yes| E[onEarlyTermination呼び出し]
    D -->|No| F[通常のreduce処理]
    E --> G{内部ManagerがEarlyTerminatingListener?}
    G -->|Yes| H[内部ManagerのonEarlyTermination呼び出し]
    G -->|No| I[伝播なし]
    H --> J[内部Managerのreduce実行]
    J --> K[terminatedEarly=trueを設定]
    K --> L[QuerySearchResultに結果反映]
    F --> L
    I --> L
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理のため、データベースアクセスは発生しない）。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| IOException | reduce処理中にI/Oエラーが発生した場合 | 上位の検索処理でキャッチされ、検索エラーとしてクライアントに返却される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（同期呼び出しのためリトライ不要） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（検索リクエスト数に依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし（検索リクエスト発生時に即座に処理）。

## セキュリティ考慮事項

プロセス内通知のため、外部への情報漏洩リスクはない。検索パラメータ（maxCountHits、forcedTermination）はユーザーの検索リクエストに基づく値であり、機密情報は含まない。

## 備考

- EarlyTerminatingListenerは `@opensearch.internal` アノテーションが付与されており、内部APIである
- 本通知はConcurrent Segment Search機能が有効な場合にのみ意味を持つ
- TotalHitCountCollectorManagerはEarlyTerminatingListenerを実装しており、早期終了時にterminatedAfterフィールドを設定してreduce結果に反映する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、EarlyTerminatingListenerインターフェースの定義と通知パラメータの意味を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | EarlyTerminatingListener.java | `server/src/main/java/org/opensearch/search/query/EarlyTerminatingListener.java` | onEarlyTermination(int, boolean)メソッドの2つのパラメータの意味を理解する |

**読解のコツ**: このインターフェースは非常にシンプルで、メソッドは1つだけ。Javadocのパラメータ説明を確認すること。

#### Step 2: エントリーポイントを理解する

EarlyTerminatingCollectorManagerがどのようにリスナーを呼び出すかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | EarlyTerminatingCollectorManager.java | `server/src/main/java/org/opensearch/search/query/EarlyTerminatingCollectorManager.java` | reduce()メソッド（46行目〜）で早期終了を検出し、onEarlyTermination()を呼び出す流れ |

**主要処理フロー**:
1. **46-55行目**: 各EarlyTerminatingCollectorからhasEarlyTerminated()を確認
2. **57-58行目**: 早期終了検出時にonEarlyTermination(maxCountHits, forceTermination)を呼び出し
3. **74-78行目**: onEarlyTermination実装で、内部managerがEarlyTerminatingListenerなら伝播

#### Step 3: 受信側の処理を理解する

TotalHitCountCollectorManagerが通知を受け取った後の処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | TotalHitCountCollectorManager.java | `server/src/main/java/org/opensearch/search/query/TotalHitCountCollectorManager.java` | onEarlyTermination()（63行目）でterminatedAfterフィールドを設定し、reduce()（73行目〜）でTotalHitsのRelationに反映する流れ |

**主要処理フロー**:
- **63行目**: onEarlyTermination()でterminatedAfter = maxCountHitsを記録
- **75-77行目**: reduce()でterminatedAfterがnullでなければRELATION.GREATER_THAN_OR_EQUAL_TOを設定

### プログラム呼び出し階層図

```
検索実行（QueryPhase）
    |
    +-- EarlyTerminatingCollectorManager.reduce()
            |
            +-- EarlyTerminatingCollector.hasEarlyTerminated()
            |
            +-- onEarlyTermination(maxCountHits, forceTermination)
            |       |
            |       +-- [instanceof check] 内部CollectorManager
            |               |
            |               +-- TotalHitCountCollectorManager.onEarlyTermination()
            |
            +-- 内部CollectorManager.reduce()
                    |
                    +-- QuerySearchResult.terminatedEarly(true)
```

### データフロー図

```
[入力]                         [処理]                              [出力]

maxCountHits       ------>  EarlyTerminatingCollectorManager  ----->  QuerySearchResult
forceTermination               .reduce()                              .terminatedEarly = true
                                   |                                   .totalHits.relation =
                               onEarlyTermination()                      GREATER_THAN_OR_EQUAL_TO
                                   |
                           TotalHitCountCollectorManager
                               .terminatedAfter = maxCountHits
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| EarlyTerminatingListener.java | `server/src/main/java/org/opensearch/search/query/EarlyTerminatingListener.java` | ソース | 通知インターフェース定義 |
| EarlyTerminatingCollectorManager.java | `server/src/main/java/org/opensearch/search/query/EarlyTerminatingCollectorManager.java` | ソース | 通知の送信元、早期終了検出とリスナー呼び出し |
| TotalHitCountCollectorManager.java | `server/src/main/java/org/opensearch/search/query/TotalHitCountCollectorManager.java` | ソース | 通知の受信者、TotalHitsのリレーション設定 |
| TopDocsCollectorContext.java | `server/src/main/java/org/opensearch/search/query/TopDocsCollectorContext.java` | ソース | EarlyTerminatingCollectorManagerの生成元 |
| InternalProfileCollectorManager.java | `server/src/main/java/org/opensearch/search/profile/query/InternalProfileCollectorManager.java` | ソース | プロファイリング時のEarlyTerminatingListener利用 |
