# 通知設計書 13-sd_notify（EXTEND_TIMEOUT）通知

## 概要

本ドキュメントは、OpenSearchノードの起動中にsystemdの起動タイムアウトを延長するためのsd_notify（EXTEND_TIMEOUT_USEC）通知の設計を記述する。

### 本通知の処理概要

sd_notify（EXTEND_TIMEOUT）通知は、OpenSearchの起動処理がsystemdのデフォルトタイムアウト（60秒）を超える可能性がある場合に、15秒間隔で「EXTEND_TIMEOUT_USEC=30000000」（30秒延長）メッセージをsystemdに送信して、起動タイムアウトを回避する仕組みである。

**業務上の目的・背景**：systemdはサービスタイプがnotifyの場合、デフォルトで起動完了までに60秒のタイムアウトを設けている。しかし、OpenSearchはディスク上のメタデータのアップグレード処理など、60秒を超える起動処理が発生する場合がある。タイムアウトが発生するとsystemdはサービスの起動に失敗したとみなしてプロセスを強制終了する。本通知はこのタイムアウトを回避し、起動処理が正常に完了するまで待機させることを目的とする。

**通知の送信タイミング**：createComponents()メソッド内でThreadPoolのscheduleWithFixedDelay()を使用して15秒間隔のスケジュールタスクとして設定される。ノード起動完了（READY通知送信）時にキャンセルされる。

**通知の受信者**：Linux systemdサービスマネージャがNOTIFY_SOCKETを通じて受信する。

**通知内容の概要**：文字列「EXTEND_TIMEOUT_USEC=30000000」（30秒=30,000,000マイクロ秒のタイムアウト延長）がsd_notify関数を通じて送信される。

**期待されるアクション**：systemdは起動タイムアウトのカウンタを30秒延長し、サービスの起動をさらに待機する。

## 通知種別

OS（systemd）ネイティブ通知（sd_notifyシステムコール経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（15秒間隔のスケジュールタスク） |
| 優先度 | 高（タイムアウト防止のため） |
| リトライ | なし（失敗時は警告ログのみ） |

### 送信先決定ロジック

環境変数OPENSEARCH_SD_NOTIFYがtrueに設定されている場合にのみ通知が有効化される。systemdソケットのパスはNOTIFY_SOCKET環境変数からlibsystemdが自動的に取得する。

## 通知テンプレート

### メール通知の場合

該当なし（systemdネイティブ通知）。

### 本文テンプレート

```
EXTEND_TIMEOUT_USEC=30000000
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| unset_environment | 0固定（NOTIFY_SOCKETを維持） | ハードコーディング | Yes |
| state | "EXTEND_TIMEOUT_USEC=30000000" | ハードコーディング | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジュール | 15秒間隔の定期実行 | enabled == true かつ READY通知未送信 | createComponents()でスケジュール設定、READY通知でキャンセル |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| enabled == false | 環境変数OPENSEARCH_SD_NOTIFYがtrue以外の場合 |
| READY通知送信済み | onNodeStarted()でextenderがキャンセルされた後 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[createComponents呼び出し] --> B{enabled?}
    B -->|No| C[extenderをnullに設定]
    B -->|Yes| D[15秒間隔のスケジュールタスク設定]
    D --> E[15秒待機]
    E --> F[sd_notify 0, EXTEND_TIMEOUT_USEC=30000000]
    F --> G{戻り値 rc}
    G -->|rc >= 0| H[次の15秒を待機]
    G -->|rc < 0| I[警告ログ出力]
    I --> H
    H --> J{READY通知でキャンセルされた?}
    J -->|No| E
    J -->|Yes| K[スケジュール終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（OSレベルの通知のため、データベースアクセスは発生しない）。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| sd_notify失敗 | sd_notifyが負の値を返した場合 | 警告ログ出力のみ（起動処理は継続） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（ただし15秒後に次のスケジュール実行で再試行） |
| リトライ間隔 | 15秒（スケジュール間隔） |
| リトライ対象エラー | sd_notifyの負の戻り値 |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 4回（15秒間隔） |
| 1日あたり上限 | なし（起動時のみ） |

### 配信時間帯

制限なし（ノード起動中に限り送信）。

## セキュリティ考慮事項

- sd_notify呼び出しはUNIXドメインソケット（NOTIFY_SOCKET）を経由するため、ネットワーク上の盗聴リスクはない
- ThreadPool.Names.SAMEスレッドで実行されるため、スレッド安全性に注意

## 備考

- 延長するタイムアウト値は30秒（30,000,000マイクロ秒）固定
- 送信間隔は15秒固定（TimeValue.timeValueSeconds(15)）
- READY通知（No.12）が送信されると本スケジュールタスクはキャンセルされる
- 失敗してもノード起動は継続する（READY通知の失敗とは異なる扱い）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

sd_notifyのネイティブインターフェースとスケジューラの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Libsystemd.java | `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` | sd_notifyネイティブメソッドの引数と戻り値の意味 |

**読解のコツ**: sd_notifyの戻り値は負の値がエラー、正の値が成功を示す。

#### Step 2: エントリーポイントを理解する

createComponents()内でのスケジュールタスク設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SystemdModulePlugin.java | `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` | createComponents()（92行目〜）でのスケジュール設定とsd_notify呼び出し |

**主要処理フロー**:
1. **105-108行目**: enabled==falseの場合はextenderをnullに設定して終了
2. **116-121行目**: scheduleWithFixedDelay()で15秒間隔のタスクを設定
3. **117行目**: タスク内でsd_notify(0, "EXTEND_TIMEOUT_USEC=30000000")を呼び出し
4. **118-119行目**: 失敗時は警告ログのみ出力

#### Step 3: キャンセル処理を理解する

READY通知送信後のスケジュールキャンセルを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SystemdModulePlugin.java | `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` | onNodeStarted()（132行目〜）でextender.cancel()が呼ばれる |

**主要処理フロー**:
- **143行目**: extender.get().cancel()でスケジュールタスクをキャンセル

### プログラム呼び出し階層図

```
Node.createComponents()
    |
    +-- SystemdModulePlugin.createComponents()
            |
            +-- ThreadPool.scheduleWithFixedDelay(15秒間隔)
                    |
                    +-- [定期実行] SystemdModulePlugin.sd_notify(0, "EXTEND_TIMEOUT_USEC=30000000")
                            |
                            +-- Libsystemd.sd_notify()
                                    |
                                    +-- [JNA] libsystemd.so.0 :: sd_notify()

Node.onNodeStarted()
    |
    +-- SystemdModulePlugin.onNodeStarted()
            |
            +-- extender.cancel()  <-- スケジュール停止
```

### データフロー図

```
[入力]                         [処理]                              [出力]

OPENSEARCH_SD_NOTIFY=true --> createComponents()                 --> sd_notify(0, "EXTEND_TIMEOUT_USEC=30000000")
                                  |                                      |
                              scheduleWithFixedDelay(15s)           --> systemd NOTIFY_SOCKET
                                  |                                      (タイムアウト延長通知)
                              onNodeStarted()
                                  |
                              extender.cancel()                    --> スケジュール停止
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SystemdModulePlugin.java | `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` | ソース | EXTEND_TIMEOUT通知のスケジュール設定・送信・キャンセル |
| Libsystemd.java | `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` | ソース | sd_notifyネイティブメソッドのJNAバインディング |
| SystemdModulePluginTests.java | `modules/systemd/src/test/java/org/opensearch/systemd/SystemdModulePluginTests.java` | テスト | EXTEND_TIMEOUT通知のテスト |
