# 通知設計書 14-sd_notify（STOPPING）通知

## 概要

本ドキュメントは、OpenSearchノードのシャットダウン時にsystemdサービスマネージャに対してサービス停止中を通知するsd_notify（STOPPING=1）通知の設計を記述する。

### 本通知の処理概要

sd_notify（STOPPING）通知は、OpenSearchノードがシャットダウン処理を開始した際にsystemdに対して「STOPPING=1」メッセージを送信し、サービスが停止処理中であることを通知する仕組みである。

**業務上の目的・背景**：systemd環境でOpenSearchをサービスとして運用する場合、systemdはサービスの停止状態を正確に把握する必要がある。STOPPING=1を送信することで、systemdはサービスが正常にシャットダウン処理を開始したことを認識し、停止タイムアウトのカウントダウンを適切に開始できる。これにより、systemdの管理画面やログにおいて正確なサービス状態が反映される。

**通知の送信タイミング**：SystemdModulePluginのclose()メソッドが呼ばれた時点で送信される。これはプラグインのライフサイクルにおけるシャットダウン処理のコールバックである。

**通知の受信者**：Linux systemdサービスマネージャがNOTIFY_SOCKETを通じて受信する。

**通知内容の概要**：文字列「STOPPING=1」がsd_notify関数を通じて送信される。

**期待されるアクション**：systemdはサービスが停止処理中であることを認識し、サービスの状態を「deactivating」に遷移させる。

## 通知種別

OS（systemd）ネイティブ通知（sd_notifyシステムコール経由）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（sd_notify JNA呼び出し） |
| 優先度 | 中（停止状態の通知） |
| リトライ | なし（失敗時は警告ログのみ） |

### 送信先決定ロジック

環境変数OPENSEARCH_SD_NOTIFYがtrueに設定されている場合にのみ通知が有効化される。

## 通知テンプレート

### メール通知の場合

該当なし（systemdネイティブ通知）。

### 本文テンプレート

```
STOPPING=1
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| unset_environment | 0固定（NOTIFY_SOCKETを維持） | ハードコーディング | Yes |
| state | "STOPPING=1" | ハードコーディング | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ノードライフサイクル | close()コールバック | enabled == true | ノードシャットダウン時にプラグインフレームワークから呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| enabled == false | 環境変数OPENSEARCH_SD_NOTIFYがtrue以外の場合、通知は送信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[シャットダウン開始] --> B[close呼び出し]
    B --> C{enabled?}
    C -->|No| D[何もしない]
    C -->|Yes| E[sd_notify 0, STOPPING=1 呼び出し]
    E --> F{戻り値 rc}
    F -->|rc >= 0| G[正常終了]
    F -->|rc < 0| H[警告ログ出力]
    H --> G
    D --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| sd_notify失敗 | sd_notifyが負の値を返した場合 | 警告ログ出力のみ（シャットダウン処理は継続） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし（失敗時は警告ログのみ、シャットダウン継続） |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（シャットダウン時に1回のみ） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- sd_notify呼び出しはUNIXドメインソケットを経由するため、ネットワーク上の盗聴リスクはない

## 備考

- STOPPING通知の失敗はシャットダウン処理の失敗として扱われない（警告ログのみ）
- これはREADY通知（No.12）の失敗がRuntimeExceptionをスローするのとは対照的な設計
- systemdのコメントに「do not treat failure to notify systemd of stopping as a failure」と明記されている

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Libsystemd.java | `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` | sd_notifyネイティブメソッドのインターフェース |

**読解のコツ**: READY通知（No.12）、EXTEND_TIMEOUT通知（No.13）と同じsd_notifyメソッドを使用する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SystemdModulePlugin.java | `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` | close()（148行目〜）でSTOPPING通知を送信する流れ |

**主要処理フロー**:
1. **149-151行目**: enabled==falseの場合はreturn
2. **152行目**: sd_notify(0, "STOPPING=1")呼び出し
3. **153-156行目**: 負の戻り値の場合は警告ログのみ出力

### プログラム呼び出し階層図

```
Node.close()
    |
    +-- Plugin.close()
            |
            +-- SystemdModulePlugin.close()
                    |
                    +-- SystemdModulePlugin.sd_notify(0, "STOPPING=1")
                            |
                            +-- Libsystemd.sd_notify(0, "STOPPING=1")
                                    |
                                    +-- [JNA] libsystemd.so.0 :: sd_notify()
```

### データフロー図

```
[入力]                   [処理]                      [出力]

シャットダウン開始 --> SystemdModulePlugin.close() --> sd_notify(0, "STOPPING=1")
                                                        |
                                                    --> systemd NOTIFY_SOCKET
                                                        (サービス停止通知)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SystemdModulePlugin.java | `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` | ソース | STOPPING通知の送信ロジック |
| Libsystemd.java | `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` | ソース | sd_notifyネイティブメソッドのJNAバインディング |
| SystemdModulePluginTests.java | `modules/systemd/src/test/java/org/opensearch/systemd/SystemdModulePluginTests.java` | テスト | STOPPING通知のテスト |
