# 通知設計書 16-DeprecationHandler通知

## 概要

本ドキュメントは、XContentパーサーにおいて非推奨フィールドが使用された際にコールバックで通知するDeprecationHandler通知の設計を記述する。

### 本通知の処理概要

DeprecationHandlerは、XContentParser（JSON/YAML/CBORなどのコンテンツパーサー）が非推奨フィールドを検出した際に、その情報をコールバックメソッドで通知するインターフェースである。

**業務上の目的・背景**：OpenSearchのAPIは進化に伴いフィールド名の変更や廃止が発生する。後方互換性を維持しつつ、ユーザーに対して非推奨フィールドの使用を警告する必要がある。DeprecationHandlerはこの警告メカニズムの基盤を提供し、パーサーが非推奨フィールドを検出した際にアプリケーション固有の対応（ログ出力、例外スロー、無視など）を柔軟に実装可能にする。

**通知の送信タイミング**：XContentParser内で非推奨フィールド名が検出された時点でusedDeprecatedName()またはusedDeprecatedField()コールバックが呼び出される。

**通知の受信者**：DeprecationHandlerインターフェースの実装クラスが受信者となる。既定実装として、THROW_UNSUPPORTED_OPERATION（例外をスローする）とIGNORE_DEPRECATIONS（無視する）の2つが提供されている。

**通知内容の概要**：パーサー名、コンテンツ内の位置情報（行番号・列番号）、使用されたフィールド名、および代替フィールド名が通知される。

**期待されるアクション**：実装に応じて、非推奨警告のログ出力、例外のスロー、または無視の処理が行われる。THROW_UNSUPPORTED_OPERATIONの場合はUnsupportedOperationExceptionがスローされ、パース処理が中断される。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるメソッド呼び出し）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（パーサー内での直接呼び出し） |
| 優先度 | 中（非推奨警告） |
| リトライ | なし |

### 送信先決定ロジック

XContentParserの生成時にDeprecationHandlerが指定される。パーサーはフィールド名の解決時に非推奨フィールドを検出した場合、設定されたハンドラに通知する。

## 通知テンプレート

### メール通知の場合

該当なし（プロセス内コールバック通知）。

### 本文テンプレート

```
THROW_UNSUPPORTED_OPERATIONの場合（3パターン）:

パターン1（非推奨名で代替あり）:
deprecated fields not supported in [{parserName}] but got [{usedName}] at [{location}] which has been replaced with [{modernName}]

パターン2（非推奨フィールドで代替あり）:
deprecated fields not supported in [{parserName}] but got [{usedName}] at [{location}] which is a deprecated name for [{replacedWith}]

パターン3（非推奨フィールドで代替なし）:
deprecated fields not supported in [{parserName}] but got [{usedName}] at [{location}] which has been deprecated entirely
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| parserName | パーサー名 | XContentParser生成時の引数 | No（nullの場合は簡略メッセージ） |
| location | コンテンツ内の位置 | Supplier<XContentLocation> | Yes |
| usedName | 使用された非推奨フィールド名 | パーサーのフィールド解決結果 | Yes |
| modernName / replacedWith | 代替フィールド名 | フィールドマッピング定義 | メソッドによる |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| パーサー処理 | usedDeprecatedName呼び出し | フィールド名が非推奨名に一致 | フィールド名が古い名前で使用された場合 |
| パーサー処理 | usedDeprecatedField（代替あり）呼び出し | フィールド自体が非推奨で代替フィールドあり | フィールドが別フィールドに置き換えられた場合 |
| パーサー処理 | usedDeprecatedField（代替なし）呼び出し | フィールド自体が非推奨で代替なし | フィールドが完全に非推奨になった場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| IGNORE_DEPRECATIONSハンドラ使用時 | すべての非推奨通知が無視される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[XContentParser フィールド解決] --> B{非推奨フィールド検出?}
    B -->|No| C[通常処理継続]
    B -->|Yes| D{通知種別判定}
    D -->|名前変更| E[usedDeprecatedName呼び出し]
    D -->|フィールド置換| F[usedDeprecatedField代替あり呼び出し]
    D -->|完全非推奨| G[usedDeprecatedField代替なし呼び出し]
    E --> H{ハンドラ実装}
    F --> H
    G --> H
    H -->|THROW_UNSUPPORTED_OPERATION| I[UnsupportedOperationExceptionスロー]
    H -->|IGNORE_DEPRECATIONS| J[何もしない]
    H -->|カスタム実装| K[アプリケーション固有処理]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| UnsupportedOperationException | THROW_UNSUPPORTED_OPERATIONハンドラ使用時 | パース処理が中断され、呼び出し元に例外が伝播 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | なし |
| リトライ対象エラー | なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし（パーサー実行回数に依存） |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- 非推奨フィールド名はAPIの公開情報であり、機密情報は含まない
- DeprecationHandlerは@PublicApi(since = "1.0.0")が付与されており、安定したパブリックAPIとして提供されている

## 備考

- 3つのコールバックメソッドが定義されている：usedDeprecatedName、usedDeprecatedField（代替あり）、usedDeprecatedField（代替なし）
- parserNameがnullの場合はパーサー名なしの簡略メッセージが使用される
- THROW_UNSUPPORTED_OPERATIONは主にテストやstrictモードで使用される
- IGNORE_DEPRECATIONSは非推奨警告を無視したい場合に使用される

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DeprecationHandlerインターフェースの3つのコールバックメソッドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | DeprecationHandler.java | `libs/core/src/main/java/org/opensearch/core/xcontent/DeprecationHandler.java` | 3つのメソッドシグネチャ（141, 149, 156行目）と共通パラメータの意味 |

**読解のコツ**: 3つのメソッドの違いに注目。usedDeprecatedName（名前変更）、usedDeprecatedField（代替あり）、usedDeprecatedField（代替なし）の用途の違いを理解する。

#### Step 2: 既定実装を理解する

THROW_UNSUPPORTED_OPERATIONとIGNORE_DEPRECATIONSの2つの既定実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DeprecationHandler.java | `libs/core/src/main/java/org/opensearch/core/xcontent/DeprecationHandler.java` | THROW_UNSUPPORTED_OPERATION（53行目〜）で例外メッセージのフォーマットを確認 |
| 2-2 | DeprecationHandler.java | `libs/core/src/main/java/org/opensearch/core/xcontent/DeprecationHandler.java` | IGNORE_DEPRECATIONS（119行目〜）で空実装を確認 |

**主要処理フロー**:
1. **53-114行目**: THROW_UNSUPPORTED_OPERATION - parserNameのnull判定によるメッセージ分岐
2. **119-134行目**: IGNORE_DEPRECATIONS - 空のメソッド実装

### プログラム呼び出し階層図

```
XContentParser（JSON/YAML/CBORパーサー）
    |
    +-- フィールド名解決
            |
            +-- 非推奨フィールド検出
                    |
                    +-- DeprecationHandler.usedDeprecatedName(parserName, location, usedName, modernName)
                    |       |
                    |       +-- [THROW] UnsupportedOperationException
                    |       +-- [IGNORE] no-op
                    |
                    +-- DeprecationHandler.usedDeprecatedField(parserName, location, usedName, replacedWith)
                    |       |
                    |       +-- [THROW] UnsupportedOperationException
                    |       +-- [IGNORE] no-op
                    |
                    +-- DeprecationHandler.usedDeprecatedField(parserName, location, usedName)
                            |
                            +-- [THROW] UnsupportedOperationException
                            +-- [IGNORE] no-op
```

### データフロー図

```
[入力]                              [処理]                        [出力]

非推奨フィールド名  ---------->  XContentParser              --> DeprecationHandler
parserName                         フィールド解決                  コールバック呼び出し
XContentLocation                       |                            |
                                   非推奨検出                 --> UnsupportedOperationException
                                                                  (THROW_UNSUPPORTEDの場合)
                                                              --> 無視
                                                                  (IGNORE_DEPRECATIONSの場合)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| DeprecationHandler.java | `libs/core/src/main/java/org/opensearch/core/xcontent/DeprecationHandler.java` | ソース | 通知インターフェース定義と既定実装 |
| XContentParser.java | `libs/core/src/main/java/org/opensearch/core/xcontent/XContentParser.java` | ソース | DeprecationHandlerの利用元パーサー |
| XContentLocation.java | `libs/core/src/main/java/org/opensearch/core/xcontent/XContentLocation.java` | ソース | コンテンツ内位置情報 |
