# 通知設計書 19-FollowersChecker通知

## 概要

本ドキュメントは、リーダーノードがフォロワーノードへの定期的なヘルスチェックを実行し、フォロワー障害を検出してクラスタから除外する通知を行うFollowersChecker通知の設計を記述する。

### 本通知の処理概要

FollowersCheckerは、リーダーノードが全フォロワーノードに対して定期的にヘルスチェックリクエストを送信し、応答の成功・失敗を監視する。設定されたリトライ回数を超えて連続失敗した場合、または接続切断やヘルスチェック失敗を検出した場合に、対象フォロワーノードをfaultyNodesに追加し、onNodeFailureコールバックを通じてクラスタからの除外を通知する。

**業務上の目的・背景**：OpenSearchクラスタでは、障害を起こしたノードを速やかに検出してクラスタから除外し、シャードの再割り当てを行う必要がある。FollowersCheckerはリーダーノードによるフォロワーの健全性監視を担い、障害ノードの検出と除外プロセスの起点となる。一時的なネットワーク障害やGCポーズによる誤検出を防ぐため、複数回のリトライを許容する設計となっている。

**通知の送信タイミング**：(1) ヘルスチェックの連続失敗回数がfollowerCheckRetryCount（デフォルト3）を超えた場合。(2) 接続切断（ConnectTransportException）を検出した場合。(3) フォロワーのヘルスチェックが失敗（NodeHealthCheckFailureException）した場合。(4) TransportConnectionListenerによるフォロワーノード切断検出時。

**通知の受信者**：Coordinatorクラスのノード障害ハンドラ（BiConsumer<DiscoveryNode, String> onNodeFailure）が受信者である。

**通知内容の概要**：障害が発生したDiscoveryNodeと障害理由（"disconnected"、"health check failed"、"followers check retry count exceeded"、"lagging"）が通知される。

**期待されるアクション**：Coordinatorがフォロワーノードをクラスタから除外し、シャードの再割り当てを行う。

## 通知種別

プロセス内コールバック通知（BiConsumer<DiscoveryNode, String>による非同期通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（generic ThreadPoolで実行） |
| 優先度 | 最高（クラスタ構成の整合性に直結） |
| リトライ | チェック自体がリトライ機構（デフォルト3回失敗で通知） |

### 送信先決定ロジック

setCurrentNodes()でクラスタ内の全ノード一覧が設定され、各フォロワーに対して個別のFollowerCheckerインスタンスが作成される。ローカルノード（リーダー自身）とfaultyNodesに含まれるノードは除外される。

## 通知テンプレート

### メール通知の場合

該当なし。

### 本文テンプレート

```
該当なし（DiscoveryNode + String reasonが渡される）

理由文字列:
- "disconnected" - 接続切断時
- "health check failed" - ヘルスチェック失敗時
- "followers check retry count exceeded" - リトライ回数超過時
- "lagging" - (外部使用向け定義)
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| discoveryNode | 障害フォロワーノード | FollowerChecker.discoveryNode | Yes |
| reason | 障害理由文字列 | 障害タイプに応じた定数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| トランスポート | ヘルスチェック応答エラー | 連続失敗回数 >= followerCheckRetryCount | デフォルト3回連続失敗 |
| トランスポート | ConnectTransportException | 即座に通知 | 接続切断は即座にフォロワー障害と判定 |
| トランスポート | NodeHealthCheckFailureException | 即座に通知 | フォロワーが不健全と報告 |
| トランスポート | TransportConnectionListener.onNodeDisconnected | フォロワーノードが切断 | フォロワーとの接続断を即座に検出 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| FollowerCheckerが停止済み | running()==falseの場合は通知しない |
| 連続失敗回数が閾値未満 | リトライ回数未満の場合は次のチェックをスケジュール |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[setCurrentNodes ノード一覧設定] --> B[各フォロワーにFollowerChecker開始]
    B --> C[handleWakeUp]
    C --> D[FollowerCheckRequest送信]
    D --> E{応答結果}
    E -->|成功| F[failureCount=0 次のチェックスケジュール]
    E -->|ConnectTransportException| G[failNode disconnected]
    E -->|NodeHealthCheckFailureException| H[failNode health check failed]
    E -->|その他エラー| I{failureCount >= retryCount?}
    I -->|Yes| J[failNode retry count exceeded]
    I -->|No| K[failureCount++ 次のチェックスケジュール]
    F --> C
    K --> C
    G --> L[faultyNodesに追加]
    H --> L
    J --> L
    L --> M[followerCheckersから削除]
    M --> N[onNodeFailure.accept node, reason]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（インメモリ処理）。

### 更新テーブル一覧

該当なし。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| ConnectTransportException | フォロワーとの接続失敗 | 即座にfailNode("disconnected") |
| NodeHealthCheckFailureException | フォロワーが不健全と報告 | 即座にfailNode("health check failed") |
| TransportException | その他のトランスポートエラー | リトライカウントに加算、閾値超過でfailNode |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | cluster.fault_detection.follower_check.retry_count（デフォルト3） |
| リトライ間隔 | cluster.fault_detection.follower_check.interval（デフォルト1000ms） |
| リトライ対象エラー | ConnectTransportExceptionとNodeHealthCheckFailureException以外のTransportException |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| チェック間隔 | cluster.fault_detection.follower_check.interval（デフォルト1000ms、最小100ms、Dynamic） |
| チェックタイムアウト | cluster.fault_detection.follower_check.timeout（デフォルト10000ms、最小1ms、最大150000ms、Dynamic） |

### 配信時間帯

制限なし（リーダーノード稼働中は常時チェック）。

## セキュリティ考慮事項

- ヘルスチェックリクエストはトランスポート層を経由するため、TLS/SSL設定に依存
- フォロワーチェックのアクション名は内部API（"internal:coordination/fault_detection/follower_check"）
- Fast Response Path（235-238行目）により、正常時はネットワークスレッド上で即座に応答し、処理負荷を最小化

## 備考

- followerCheckInterval/followerCheckTimeoutはDynamic属性で動的変更可能
- FastResponseStateにより、正常時（FOLLOWER モード、同一term）は高速パスで即座に応答
- 障害ノードはfaultyNodesセットで管理され、setCurrentNodes()で不明ノードが除去される
- FollowerCheckRequestにはtermフィールドが含まれ、term不一致時は拒否される
- followerChecksFailureCounterメトリクスで障害検出数を記録
- NODE_LEFT_REASON定数で障害理由が定義されている（LAGGING, DISCONNECTED, HEALTHCHECK_FAIL, FOLLOWER_CHECK_RETRY_FAIL）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

チェックリクエストの構造と設定パラメータ、FastResponseStateの仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | FollowerCheckRequest（487行目〜）の構造（term, sender）とSetting定義（95-119行目） |
| 1-2 | FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | FastResponseState（324行目〜）とNODE_LEFT_REASON定数（89-92行目） |

**読解のコツ**: LeaderCheckerと対比して読むとよい。LeaderCheckerはフォロワーがリーダー1台をチェックするのに対し、FollowersCheckerはリーダーが全フォロワーをチェックする。

#### Step 2: エントリーポイントを理解する

コンストラクタとsetCurrentNodes()でのチェッカー管理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | コンストラクタ（138行目〜）でのリクエストハンドラ登録とConnectionListener登録 |
| 2-2 | FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | setCurrentNodes()（187行目〜）でのFollowerChecker作成・削除 |

**主要処理フロー**:
1. **159-166行目**: FOLLOWER_CHECK_ACTION_NAMEのリクエストハンドラ登録
2. **167-172行目**: TransportConnectionListenerでノード切断検出
3. **187-204行目**: setCurrentNodes()で差分管理（新規追加/不明ノード削除）

#### Step 3: チェック実行と障害検出を理解する

FollowerChecker内部クラスの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | FollowerChecker.handleWakeUp()（361行目〜）でのリクエスト送信とレスポンスハンドリング |

**主要処理フロー**:
- **370-374行目**: FollowerCheckRequest送信
- **382-390行目**: 成功時はfailureCount=0にリセット
- **394-418行目**: 失敗時の分岐（接続切断/ヘルスチェック失敗/リトライ超過/リトライ継続）

#### Step 4: failNode処理を理解する

障害ノードの登録とコールバック通知を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | failNode()（429行目〜）でのfaultyNodes追加、followerCheckers削除、onNodeFailure呼び出し |

**主要処理フロー**:
- **430行目**: followerChecksFailureCounterメトリクス記録
- **434-441行目**: synchronized(mutex)内でrunning()確認、faultyNodes追加、followerCheckers削除
- **443行目**: onNodeFailure.accept(discoveryNode, reason)で通知

### プログラム呼び出し階層図

```
Coordinator
    |
    +-- FollowersChecker.setCurrentNodes(discoveryNodes)
            |
            +-- [各フォロワー] FollowerChecker(discoveryNode)
                    |
                    +-- start() -> handleWakeUp()
                    |       |
                    |       +-- transportService.sendRequest(FOLLOWER_CHECK_ACTION_NAME)
                    |       |       |
                    |       |       +-- [成功] failureCount=0, scheduleNextWakeUp()
                    |       |       +-- [失敗] failNode() or scheduleNextWakeUp()
                    |       |
                    |       +-- scheduleNextWakeUp() [1000ms後]
                    |
                    +-- failNode(reason)
                            |
                            +-- clusterManagerMetrics.incrementCounter()
                            +-- synchronized(mutex):
                            |     faultyNodes.add(node)
                            |     followerCheckers.remove(node)
                            +-- onNodeFailure.accept(node, reason)
```

### データフロー図

```
[入力]                             [処理]                              [出力]

FollowerCheckRequest         -->  TransportService.sendRequest()   --> [成功] scheduleNextWakeUp()
  term: currentTerm                    |                            --> [失敗] failNode(reason)
  sender: localNode              handleResponse/handleException            |
                                                                    --> onNodeFailure.accept(node, reason)
DiscoveryNodes               -->  setCurrentNodes()                      |
  (全ノード一覧)                      |                            --> Coordinator
                                  FollowerChecker差分管理               (ノード除外/シャード再割り当て)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| FollowersChecker.java | `server/src/main/java/org/opensearch/cluster/coordination/FollowersChecker.java` | ソース | フォロワーチェック通知の主要実装 |
| Coordinator.java | `server/src/main/java/org/opensearch/cluster/coordination/Coordinator.java` | ソース | onNodeFailureコールバックの提供元 |
| NodeHealthService.java | `server/src/main/java/org/opensearch/monitor/NodeHealthService.java` | ソース | ノードヘルスチェック |
| NodeHealthCheckFailureException.java | `server/src/main/java/org/opensearch/cluster/coordination/NodeHealthCheckFailureException.java` | ソース | ヘルスチェック失敗例外 |
| ClusterManagerMetrics.java | `server/src/main/java/org/opensearch/cluster/ClusterManagerMetrics.java` | ソース | メトリクス記録 |
| FollowersCheckerTests.java | `server/src/test/java/org/opensearch/cluster/coordination/FollowersCheckerTests.java` | テスト | フォロワーチェックのテスト |
