# 通知設計書 2-ClusterStateTaskListener通知

## 概要

本ドキュメントは、OpenSearchにおけるClusterStateTaskListener通知の設計仕様を記載する。ClusterStateTaskListenerはクラスタ状態タスクの実行結果（成功・失敗・クラスタマネージャー喪失）をリスナーに通知するためのインターフェースであり、ClusterManagerServiceに投入されたタスクのライフサイクル管理に使用される。

### 本通知の処理概要

ClusterStateTaskListener通知は、クラスタ状態を変更するタスクが実行された後、その結果をタスク投入元に通知する仕組みである。

**業務上の目的・背景**：OpenSearchのクラスタ状態変更は、ClusterManagerServiceに投入されるタスクとして管理される。インデックス作成、シャード割り当て変更、メタデータ更新などの操作は、すべてクラスタ状態タスクとして実行される。タスクの投入元は、タスクの成功・失敗を知る必要があり、ClusterStateTaskListenerはこの結果通知を提供する。特にクラスタマネージャーの喪失時には、投入済みタスクが実行不能になるため、その通知が不可欠である。

**通知の送信タイミング**：3つのタイミングで通知が発生する。(1) タスク実行が失敗した場合にonFailure()が呼ばれる。(2) クラスタマネージャーでなくなった場合にonNoLongerClusterManager()が呼ばれる。(3) タスクの結果が全リスナーに正常に処理された後にclusterStateProcessed()が呼ばれる。

**通知の受信者**：ClusterStateTaskListenerインターフェースを実装し、ClusterManagerServiceにタスクを投入したコンポーネントが受信者となる。

**通知内容の概要**：onFailure()はソース文字列と例外オブジェクトを受け取る。onNoLongerClusterManager()はソース文字列を受け取る（デフォルト実装ではNotClusterManagerExceptionを生成してonFailure()に委譲）。clusterStateProcessed()はソース文字列、変更前ClusterState、変更後ClusterStateを受け取る。

**期待されるアクション**：タスク投入元は、onFailure()で例外に応じたエラーハンドリングを実行する。onNoLongerClusterManager()ではリトライまたはエラー応答を行う。clusterStateProcessed()では後続処理（クライアントへの応答など）を実行する。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるリスナーパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（クラスタマネージャースレッド上で実行） |
| 優先度 | 高（タスク結果通知は即時処理が必要） |
| リトライ | 無し |

### 送信先決定ロジック

タスク投入時にClusterStateTaskListenerとして登録されたリスナーに対して通知する。タスクとリスナーは1対1で対応する。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaメソッドコールバックとして通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| source | タスクのソース識別子 | タスク投入時に指定 | Yes |
| exception | 失敗時の例外オブジェクト | ClusterStateTaskExecutor | onFailure時のみ |
| oldState | 変更前のクラスタ状態 | ClusterApplierService | clusterStateProcessed時のみ |
| newState | 変更後のクラスタ状態 | ClusterApplierService | clusterStateProcessed時のみ |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| タスク実行失敗 | ClusterStateTaskExecutor#execute()で例外発生 | 例外がスローされること | onFailure(source, exception)が呼ばれる |
| クラスタマネージャー喪失 | ローカルノードがクラスタマネージャーでなくなった | タスクがClusterManagerServiceに投入済み | onNoLongerClusterManager(source)が呼ばれる |
| タスク正常完了 | タスクの結果が全リスナーに正常処理された | タスク実行と結果配信が正常完了 | clusterStateProcessed(source, oldState, newState)が呼ばれる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | タスクの結果は必ず通知される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タスク投入] --> B[ClusterManagerService#submitStateUpdateTask]
    B --> C{タスク実行結果}
    C -->|成功| D[clusterStateProcessed呼び出し]
    C -->|失敗| E[onFailure呼び出し]
    C -->|CM喪失| F[onNoLongerClusterManager呼び出し]
    D --> G[終了]
    E --> G
    F --> H[デフォルト: NotClusterManagerExceptionでonFailure委譲]
    H --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

### テーブル別参照項目詳細

N/A

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | N/A |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| タスク実行失敗 | ClusterStateTaskExecutor内で例外発生 | onFailure()コールバックで通知 |
| クラスタマネージャー喪失 | ノードがクラスタマネージャーロールを喪失 | onNoLongerClusterManager()コールバックで通知（デフォルトではonFailure()に委譲） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし。リトライはタスク投入元の責任） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

タスク結果にはクラスタ状態情報が含まれる可能性がある。プロセス内通知であるため、ネットワーク上のセキュリティリスクは限定的。

## 備考

- @PublicApi(since = "1.0.0")として公開APIに指定されている
- onNoLongerClusterManager()のデフォルト実装はNotClusterManagerExceptionを生成してonFailure()に委譲する
- clusterStateProcessed()のデフォルト実装は空（何もしない）
- ClusterManagerServiceに投入されるタスク専用のリスナーであり、一般的なClusterStateListenerとは用途が異なる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | ClusterStateTaskListener.java | `server/src/main/java/org/opensearch/cluster/ClusterStateTaskListener.java` | 3つのコールバックメソッド定義（行50, 56, 64） |

**読解のコツ**: onFailure()は抽象メソッド（必須実装）、onNoLongerClusterManager()とclusterStateProcessed()はデフォルト実装付き。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ClusterManagerService.java | `server/src/main/java/org/opensearch/cluster/service/ClusterManagerService.java` | submitStateUpdateTaskメソッドでタスクとリスナーが紐づく |

**主要処理フロー**:
1. **行50**: `onFailure(String source, Exception e)` - 必須実装のエラー通知
2. **行56-58**: `onNoLongerClusterManager(String source)` - デフォルトでNotClusterManagerExceptionを生成しonFailureに委譲
3. **行64**: `clusterStateProcessed(String source, ClusterState oldState, ClusterState newState)` - デフォルト空実装

#### Step 3: ClusterStateTaskExecutorを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ClusterStateTaskExecutor.java | `server/src/main/java/org/opensearch/cluster/ClusterStateTaskExecutor.java` | execute()メソッドでタスクを実行し、結果に応じてリスナーに通知 |

### プログラム呼び出し階層図

```
ClusterManagerService#submitStateUpdateTask()
    |
    +-- ClusterStateTaskExecutor#execute()
            |
            +-- [成功時] listener.clusterStateProcessed(source, oldState, newState)
            |
            +-- [失敗時] listener.onFailure(source, exception)
            |
            +-- [CM喪失時] listener.onNoLongerClusterManager(source)
                    |
                    +-- [デフォルト] listener.onFailure(source, NotClusterManagerException)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

タスク投入  ───▶ ClusterManagerService  ───▶ ClusterStateTaskExecutor
                                                     |
                                            ┌────────┼────────┐
                                            v        v        v
                                       onFailure  clusterState  onNoLonger
                                                  Processed    ClusterManager
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ClusterStateTaskListener.java | `server/src/main/java/org/opensearch/cluster/ClusterStateTaskListener.java` | ソース | リスナーインターフェース定義 |
| ClusterStateTaskExecutor.java | `server/src/main/java/org/opensearch/cluster/ClusterStateTaskExecutor.java` | ソース | タスク実行エンジン |
| ClusterManagerService.java | `server/src/main/java/org/opensearch/cluster/service/ClusterManagerService.java` | ソース | タスク投入・管理サービス |
| NotClusterManagerException.java | `server/src/main/java/org/opensearch/cluster/NotClusterManagerException.java` | ソース | CM喪失時の例外クラス |
