# 通知設計書 4-TransportConnectionListener通知

## 概要

本ドキュメントは、OpenSearchにおけるTransportConnectionListener通知の設計仕様を記載する。TransportConnectionListenerはトランスポート層での接続のオープン・クローズ、ノードの接続・切断をリスナーに通知するためのインターフェースである。

### 本通知の処理概要

TransportConnectionListener通知は、OpenSearchノード間のトランスポート接続のライフサイクルイベントをリスナーに通知する仕組みである。

**業務上の目的・背景**：OpenSearchは複数ノードで構成される分散システムであり、ノード間のトランスポート接続は通信の基盤である。接続の確立・切断を追跡することで、ノードの健全性監視、接続プールの管理、クラスタメンバーシップの維持が可能になる。LeaderCheckerやFollowersCheckerなどのクラスタ発見メカニズムがこのリスナーを利用し、接続切断時にリーダー/フォロワーの障害を即座に検出している。

**通知の送信タイミング**：4つのタイミングで通知が発生する。(1) トランスポート接続がオープンされた時にonConnectionOpened()が呼ばれる。(2) トランスポート接続がクローズされた時にonConnectionClosed()が呼ばれる。(3) ノード接続が登録された時にonNodeConnected()が呼ばれる。(4) ノード接続が解除された時にonNodeDisconnected()が呼ばれる。

**通知の受信者**：TransportConnectionListenerインターフェースを実装し、TransportService#addConnectionListener()で登録したコンポーネント。

**通知内容の概要**：onConnectionOpened/onConnectionClosedではTransport.Connectionオブジェクトが渡される。onNodeConnected/onNodeDisconnectedではDiscoveryNodeとTransport.Connectionが渡される。

**期待されるアクション**：受信者は接続イベントに応じて、接続プールの更新、ノードの健全性状態の更新、障害検出ロジックの発火などを実行する。全メソッドがネットワークスレッド上で実行される可能性があるため、長時間のブロッキング操作は別スレッドにフォークする必要がある。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるリスナーパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ネットワークスレッド上で実行される可能性あり） |
| 優先度 | 高（接続イベントは即座に通知が必要） |
| リトライ | 無し |

### 送信先決定ロジック

TransportService#addConnectionListener()で登録されたすべてのTransportConnectionListenerに対して順次通知する。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaメソッドコールバックとして通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| connection | トランスポート接続オブジェクト | Transport.Connection | Yes |
| node | 接続先ノードの情報 | DiscoveryNode | onNodeConnected/onNodeDisconnected時 |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 接続オープン | トランスポート接続の確立 | 接続が成功すること | onConnectionOpened(connection) |
| 接続クローズ | トランスポート接続の切断 | 接続が閉じられること | onConnectionClosed(connection) |
| ノード接続 | ノード接続の登録 | ノード接続が確立・登録されること | onNodeConnected(node, connection) |
| ノード切断 | ノード接続の解除 | ノード接続が切断・解除されること | onNodeDisconnected(node, connection) |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | 接続イベントは常に通知される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[トランスポート接続イベント発生] --> B{イベント種別}
    B -->|接続確立| C[onConnectionOpened]
    B -->|接続切断| D[onConnectionClosed]
    B -->|ノード接続| E[onNodeConnected]
    B -->|ノード切断| F[onNodeDisconnected]
    C --> G[登録済みリスナーを順次呼び出し]
    D --> G
    E --> G
    F --> G
    G --> H[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

### テーブル別参照項目詳細

N/A

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | N/A |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー実行時例外 | コールバック内で例外がスローされた場合 | 例外はキャッチされ、後続リスナーの処理が継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

接続情報にはリモートノードのアドレス情報が含まれる。@opensearch.internalとしてマークされており、外部プラグインからの利用は想定されていない。ネットワークスレッド上で実行されるため、機密情報のロギングには注意が必要。

## 備考

- @opensearch.internalとしてマークされており、内部APIである
- 全メソッドがデフォルト実装（空）を持つため、必要なイベントのみオーバーライドすればよい
- ネットワークスレッド上で実行される可能性があるため、長時間のブロッキング操作はフォークすること
- TransportService#addConnectionListener()で登録、removeConnectionListener()で解除

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TransportConnectionListener.java | `server/src/main/java/org/opensearch/transport/TransportConnectionListener.java` | 4つのコールバックメソッド定義（行50, 56, 61, 66） |

**読解のコツ**: 全メソッドがdefault実装（空）を持つ。onConnectionOpened/Closedは低レベルの接続イベント、onNodeConnected/Disconnectedはノードレベルのイベントである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportService.java | `server/src/main/java/org/opensearch/transport/TransportService.java` | addConnectionListener()（行888）、removeConnectionListener()（行892） |

**主要処理フロー**:
1. **行888**: `addConnectionListener(TransportConnectionListener listener)` - リスナー登録
2. **行892**: `removeConnectionListener(TransportConnectionListener listener)` - リスナー解除

### プログラム呼び出し階層図

```
TransportService
    |
    +-- addConnectionListener() [行888]
    |
    +-- [接続イベント発生時]
            |
            +-- onConnectionOpened(connection)
            +-- onConnectionClosed(connection)
            +-- onNodeConnected(node, connection)
            +-- onNodeDisconnected(node, connection)
```

### データフロー図

```
[入力]                    [処理]                              [出力]

TCP接続確立    ───▶ Transport層          ───▶ onConnectionOpened(connection)
TCP接続切断    ───▶ Transport層          ───▶ onConnectionClosed(connection)
ノード接続登録 ───▶ TransportService     ───▶ onNodeConnected(node, connection)
ノード接続解除 ───▶ TransportService     ───▶ onNodeDisconnected(node, connection)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TransportConnectionListener.java | `server/src/main/java/org/opensearch/transport/TransportConnectionListener.java` | ソース | リスナーインターフェース定義 |
| TransportService.java | `server/src/main/java/org/opensearch/transport/TransportService.java` | ソース | リスナー登録・管理 |
| Transport.java | `server/src/main/java/org/opensearch/transport/Transport.java` | ソース | Transport.Connection定義 |
| DiscoveryNode.java | `server/src/main/java/org/opensearch/cluster/node/DiscoveryNode.java` | ソース | ノード情報データ構造 |
