# 通知設計書 5-TransportMessageListener通知

## 概要

本ドキュメントは、OpenSearchにおけるTransportMessageListener通知の設計仕様を記載する。TransportMessageListenerはトランスポートメッセージの送受信イベント（リクエスト受信・レスポンス送信・リクエスト送信・レスポンス受信）をリスナーに通知するためのインターフェースである。

### 本通知の処理概要

TransportMessageListener通知は、OpenSearchノード間で送受信されるトランスポートメッセージのライフサイクルイベントを追跡するための仕組みである。

**業務上の目的・背景**：分散検索エンジンにおいて、ノード間のメッセージ送受信は基本的な通信手段である。メッセージレベルのイベント追跡により、通信の監視・デバッグ・パフォーマンス分析が可能になる。リクエストの送信から応答受信までのライフサイクルを追跡でき、通信のレイテンシ測定やエラー検出に活用される。

**通知の送信タイミング**：4つの主要タイミングで通知が発生する。(1) リクエストを受信した時にonRequestReceived()が呼ばれる。(2) レスポンスを送信した後にonResponseSent()が呼ばれる（成功応答と失敗応答の2つのオーバーロードあり）。(3) リクエストを送信した後にonRequestSent()が呼ばれる。(4) レスポンスを受信した時にonResponseReceived()が呼ばれる。また、Experimental APIとしてonStreamResponseSent()も提供される。

**通知の受信者**：TransportMessageListenerインターフェースを実装し、TransportService#addMessageListener()で登録したコンポーネント。

**通知内容の概要**：各コールバックではリクエストID、アクション名が共通で渡される。加えて、onResponseSent()ではTransportResponseまたはException、onRequestSent()ではDiscoveryNode/TransportRequest/TransportRequestOptions、onResponseReceived()ではTransport.ResponseContextが渡される。

**期待されるアクション**：受信者はメッセージイベントを記録し、監視・分析に利用する。テレメトリやトレーシングの実装がこのリスナーを活用している。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるリスナーパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（トランスポートスレッド上で実行） |
| 優先度 | 中（メッセージ追跡は通信のクリティカルパス上） |
| リトライ | 無し |

### 送信先決定ロジック

TransportService#addMessageListener()で登録されたリスナーに対して通知する。NOOP_LISTENERが静的フィールドとして定義されており、リスナー未登録時はデフォルトで何もしない実装が使用される。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaメソッドコールバックとして通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| requestId | 内部リクエストID | Transport層で採番 | Yes |
| action | アクション名文字列 | リクエストから取得 | Yes |
| response | レスポンスオブジェクト | TransportResponse | onResponseSent時 |
| error | エラー例外 | Exception | 失敗レスポンス送信時 |
| node | 送信先ノード | DiscoveryNode | onRequestSent時 |
| request | リクエストオブジェクト | TransportRequest | onRequestSent時 |
| finalOptions | リクエストオプション | TransportRequestOptions | onRequestSent時 |
| context | レスポンスコンテキスト | Transport.ResponseContext | onResponseReceived時 |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| リクエスト受信 | トランスポートリクエストの受信 | リクエストを受信したこと | onRequestReceived(requestId, action) |
| レスポンス送信（成功） | 成功レスポンスの送信完了 | レスポンスが送信されたこと | onResponseSent(requestId, action, response) |
| レスポンス送信（失敗） | 失敗レスポンスの送信完了 | エラーレスポンスが送信されたこと | onResponseSent(requestId, action, error) |
| リクエスト送信 | トランスポートリクエストの送信完了 | リクエストが送信されたこと | onRequestSent(node, requestId, action, request, finalOptions) |
| レスポンス受信 | トランスポートレスポンスの受信 | レスポンスを受信したこと | onResponseReceived(requestId, context) |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | メッセージイベントは常に通知される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[トランスポートメッセージイベント] --> B{イベント種別}
    B -->|受信| C[onRequestReceived]
    B -->|成功レスポンス送信| D[onResponseSent - success]
    B -->|失敗レスポンス送信| E[onResponseSent - error]
    B -->|リクエスト送信| F[onRequestSent]
    B -->|レスポンス受信| G[onResponseReceived]
    C --> H[リスナー処理完了]
    D --> H
    E --> H
    F --> H
    G --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

### テーブル別参照項目詳細

N/A

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | N/A |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー実行時例外 | コールバック内で例外がスローされた場合 | 後続リスナーの処理を継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

メッセージ内容にはリクエスト/レスポンスデータが含まれる場合がある。@PublicApi(since = "1.0.0")としてマークされており、プラグインからも利用可能。リスナー実装側でメッセージ内容の機密性に配慮する必要がある。

## 備考

- @PublicApi(since = "1.0.0")として公開APIに指定されている
- NOOP_LISTENER静的フィールドが空の実装として提供されている
- onStreamResponseSent()は@ExperimentalApiとしてマークされたストリーミングレスポンス用コールバック
- 全メソッドがデフォルト実装（空）を持つ
- onResponseSent()は成功レスポンスとエラーレスポンスの2つのオーバーロードを持つ

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | TransportMessageListener.java | `server/src/main/java/org/opensearch/transport/TransportMessageListener.java` | 5つのコールバックメソッド定義（行57, 65, 76, 86-92, 99）とNOOP_LISTENER（行48） |

**読解のコツ**: onResponseSent()は2つのオーバーロード（成功時:TransportResponse版、失敗時:Exception版）があることに注意。onStreamResponseSent()は@ExperimentalApiであり将来変更の可能性あり。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TransportService.java | `server/src/main/java/org/opensearch/transport/TransportService.java` | addMessageListener()（行880）、removeMessageListener()（行884） |

**主要処理フロー**:
1. **行880**: `addMessageListener(TransportMessageListener listener)` - リスナー登録
2. **行884**: `removeMessageListener(TransportMessageListener listener)` - リスナー解除

### プログラム呼び出し階層図

```
TransportService
    |
    +-- addMessageListener() [行880]
    |
    +-- [メッセージイベント発生時]
            |
            +-- onRequestReceived(requestId, action)
            +-- onResponseSent(requestId, action, response)
            +-- onResponseSent(requestId, action, error)
            +-- onRequestSent(node, requestId, action, request, options)
            +-- onResponseReceived(requestId, context)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

リクエスト受信     ───▶ Transport層      ───▶ onRequestReceived(requestId, action)
レスポンス送信     ───▶ Transport層      ───▶ onResponseSent(requestId, action, response/error)
リクエスト送信     ───▶ Transport層      ───▶ onRequestSent(node, requestId, action, request, options)
レスポンス受信     ───▶ Transport層      ───▶ onResponseReceived(requestId, context)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| TransportMessageListener.java | `server/src/main/java/org/opensearch/transport/TransportMessageListener.java` | ソース | リスナーインターフェース定義 |
| TransportService.java | `server/src/main/java/org/opensearch/transport/TransportService.java` | ソース | リスナー登録・管理 |
| TransportResponse.java | `libs/core/src/main/java/org/opensearch/core/transport/TransportResponse.java` | ソース | レスポンスデータ構造 |
| TransportRequest.java | `server/src/main/java/org/opensearch/transport/TransportRequest.java` | ソース | リクエストデータ構造 |
| TransportRequestOptions.java | `server/src/main/java/org/opensearch/transport/TransportRequestOptions.java` | ソース | リクエストオプション |
