# 通知設計書 7-NotifyOnceListener通知

## 概要

本ドキュメントは、OpenSearchにおけるNotifyOnceListener通知の設計仕様を記載する。NotifyOnceListenerはActionListenerのラッパー（抽象クラス）として、onResponseまたはonFailureのいずれか一方のみが一度だけ呼ばれることを保証する通知メカニズムである。AtomicBooleanによる排他制御で二重通知を防止する。

### 本通知の処理概要

NotifyOnceListener通知は、ActionListenerの二重通知問題を解決するための仕組みである。

**業務上の目的・背景**：非同期処理において、成功と失敗のコールバックが複数回呼ばれる可能性がある。例えば、タイムアウトとレスポンスが同時に発生した場合、onFailure()とonResponse()が両方呼ばれるリスクがある。NotifyOnceListenerはこのような二重通知を防止し、リスナーが一度だけ通知を受けることを保証する。これにより、リソースの二重解放やレスポンスの二重送信といったバグを防止できる。

**通知の送信タイミング**：onResponse()またはonFailure()が最初に呼ばれた時のみ、innerOnResponse()またはinnerOnFailure()に委譲される。2回目以降の呼び出しは無視される。

**通知の受信者**：NotifyOnceListenerを継承し、innerOnResponse()とinnerOnFailure()を実装したコンポーネント。ActionListener.notifyOnce()ユーティリティメソッドで既存のActionListenerをラップすることも可能。

**通知内容の概要**：ActionListenerと同一。onResponse()ではResponseオブジェクト、onFailure()ではExceptionオブジェクトが渡される。

**期待されるアクション**：受信者はinnerOnResponse()で成功結果を処理し、innerOnFailure()でエラーハンドリングを実行する。二重通知が防止されているため、リソース解放などの一回限りの処理を安全に実行できる。

## 通知種別

プロセス内コールバック通知（ActionListenerの二重通知防止ラッパー）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（アクション完了スレッドから呼び出し） |
| 優先度 | 高（元のActionListenerと同等） |
| リトライ | 無し |

### 送信先決定ロジック

NotifyOnceListenerインスタンス自身が受信者。AtomicBooleanのcompareAndSet(false, true)による排他制御で、最初の呼び出しのみが実際の処理に到達する。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaオブジェクトとして通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| response | アクションの成功応答 | アクション実装 | onResponse時 |
| exception | アクションの失敗例外 | アクション実装 | onFailure時 |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 最初のonResponse | 成功応答の初回通知 | hasBeenCalledがfalseであること | innerOnResponse(response)に委譲 |
| 最初のonFailure | 失敗通知の初回 | hasBeenCalledがfalseであること | innerOnFailure(exception)に委譲 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に通知済み | hasBeenCalled AtomicBooleanがtrueの場合、2回目以降の通知は無視される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[onResponse or onFailure呼び出し] --> B{hasBeenCalled.compareAndSet false,true}
    B -->|成功 初回| C{呼び出しメソッド}
    B -->|失敗 2回目以降| D[無視して終了]
    C -->|onResponse| E[innerOnResponse実行]
    C -->|onFailure| F[innerOnFailure実行]
    E --> G[終了]
    F --> G
    D --> G
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

### テーブル別参照項目詳細

N/A

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | N/A |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 二重通知 | onResponse/onFailureが2回目以降呼ばれた場合 | AtomicBooleanにより呼び出しが無視される（サイレント破棄） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 1回（一度だけ通知されることを保証） |
| 1日あたり上限 | 1回 |

### 配信時間帯

制限なし

## セキュリティ考慮事項

ActionListenerと同等。@PublicApi(since = "1.0.0")としてマークされている。

## 備考

- @PublicApi(since = "1.0.0")として公開APIに指定されている
- 抽象クラスであり、innerOnResponse()とinnerOnFailure()の2つの抽象メソッドを実装する必要がある
- onResponse()とonFailure()はfinalメソッドであり、オーバーライド不可
- AtomicBoolean#compareAndSet()によるロックフリーな排他制御を採用
- ActionListener.notifyOnce()ユーティリティメソッドで既存リスナーをラップ可能

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | NotifyOnceListener.java | `libs/core/src/main/java/org/opensearch/core/action/NotifyOnceListener.java` | hasBeenCalledフィールド（行49）、onResponse/onFailureのfinalメソッド（行56-67）、innerOnResponse/innerOnFailure抽象メソッド（行51-53） |
| 1-2 | ActionListener.java | `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` | notifyOnce()ユーティリティ（行320-332） |

**読解のコツ**: NotifyOnceListenerはActionListenerを実装する抽象クラスであり、onResponse/onFailureをfinalにすることで排他制御を強制し、サブクラスにはinnerOnResponse/innerOnFailureの実装を要求する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | NotifyOnceListener.java | `libs/core/src/main/java/org/opensearch/core/action/NotifyOnceListener.java` | onResponse()メソッド（行56-59）のcompareAndSet制御 |

**主要処理フロー**:
1. **行49**: `AtomicBoolean hasBeenCalled = new AtomicBoolean(false)` - 排他制御フラグ初期化
2. **行56-59**: `onResponse()` - compareAndSet(false, true)成功時のみinnerOnResponse()を呼ぶ
3. **行63-67**: `onFailure()` - compareAndSet(false, true)成功時のみinnerOnFailure()を呼ぶ

### プログラム呼び出し階層図

```
呼び出し元
    |
    +-- onResponse(response)  [final, 行56]
    |       |
    |       +-- hasBeenCalled.compareAndSet(false, true)
    |               |
    |               +-- [true] innerOnResponse(response) [行58]
    |               +-- [false] 無視
    |
    +-- onFailure(exception)  [final, 行63]
            |
            +-- hasBeenCalled.compareAndSet(false, true)
                    |
                    +-- [true] innerOnFailure(exception) [行65]
                    +-- [false] 無視
```

### データフロー図

```
[入力]                          [処理]                              [出力]

onResponse(response) ───▶ AtomicBoolean排他制御 ───▶ innerOnResponse(response)
                               |                          又は 無視
onFailure(exception) ───▶ AtomicBoolean排他制御 ───▶ innerOnFailure(exception)
                                                          又は 無視
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| NotifyOnceListener.java | `libs/core/src/main/java/org/opensearch/core/action/NotifyOnceListener.java` | ソース | 二重通知防止抽象クラス |
| ActionListener.java | `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` | ソース | 親インターフェース・notifyOnce()ユーティリティ |
| NotifyOnceListenerTests.java | `libs/core/src/test/java/org/opensearch/core/action/NotifyOnceListenerTests.java` | テスト | 二重通知防止の動作検証テスト |
