# 通知設計書 8-RemovalNotification通知

## 概要

本ドキュメントは、OpenSearchにおけるRemovalNotification通知の設計仕様を記載する。RemovalNotificationはキャッシュエントリが削除された際に、RemovalListenerのonRemoval()を呼び出して削除理由（REPLACED/INVALIDATED/EVICTED/EXPLICIT/CAPACITY/RESTARTED）と共にキー・値を通知するデータクラスおよび通知メカニズムである。

### 本通知の処理概要

RemovalNotification通知は、キャッシュからエントリが削除されるたびに、削除理由と削除されたエントリの情報をリスナーに通知する仕組みである。

**業務上の目的・背景**：OpenSearchは高パフォーマンスを実現するために多種多様なキャッシュ（クエリキャッシュ、フィールドデータキャッシュ、リクエストキャッシュなど）を使用する。キャッシュエントリの削除時に、リソースの解放、統計情報の更新、関連データのクリーンアップなどの後処理が必要な場合がある。RemovalNotificationはこれらの後処理を実行するためのフックを提供する。

**通知の送信タイミング**：キャッシュエントリが削除された時点で通知が発生する。削除の原因は6種類のRemovalReasonで分類される：REPLACED（値の置換）、INVALIDATED（無効化）、EVICTED（エビクション）、EXPLICIT（明示的削除）、CAPACITY（容量超過）、RESTARTED（再起動時のクリア、テスト用）。

**通知の受信者**：RemovalListener<K, V>インターフェースを実装し、キャッシュに登録されたコンポーネント。@FunctionalInterfaceとしてマークされており、ラムダ式で実装可能。

**通知内容の概要**：RemovalNotification<K, V>オブジェクトが渡され、削除されたエントリのキー（getKey()）、値（getValue()）、削除理由（getRemovalReason()）を含む。

**期待されるアクション**：受信者は削除理由に応じて、リソースの解放（ファイルハンドルのクローズ、メモリの解放等）、統計カウンタの更新、関連キャッシュの連鎖的な無効化などを実行する。onRemoval()は複数スレッドから同時に呼ばれる可能性があるため、スレッドセーフな実装が必要。

## 通知種別

プロセス内コールバック通知（Javaインターフェースによるリスナーパターン）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（キャッシュ操作スレッド上で実行） |
| 優先度 | 中（キャッシュエントリ削除時のフック） |
| リトライ | 無し |

### 送信先決定ロジック

キャッシュ構築時に設定されたRemovalListenerに対して通知する。1つのキャッシュに対して1つのRemovalListenerが対応する。

## 通知テンプレート

### メール通知の場合

本通知はプロセス内コールバックであるため、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
N/A（Javaオブジェクト RemovalNotification<K, V> として通知）
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | 添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| key | 削除されたエントリのキー | RemovalNotification#getKey() | Yes |
| value | 削除されたエントリの値 | RemovalNotification#getValue() | Yes |
| removalReason | 削除理由 | RemovalNotification#getRemovalReason() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 値置換 | キャッシュエントリの値更新 | 既存キーに新しい値が設定されること | RemovalReason.REPLACED |
| 無効化 | キャッシュエントリの無効化 | エントリが無効化されること | RemovalReason.INVALIDATED |
| エビクション | キャッシュポリシーによる追い出し | LRU等のポリシーによる自動削除 | RemovalReason.EVICTED |
| 明示的削除 | プログラムによる明示的削除 | remove()等の呼び出し | RemovalReason.EXPLICIT |
| 容量超過 | キャッシュ容量の上限到達 | 新エントリ追加時に容量超過 | RemovalReason.CAPACITY |
| 再起動 | ノード再起動時のクリア | テストフレームワークでのCachedIndexInputクローズ | RemovalReason.RESTARTED |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| RemovalListenerが未設定 | キャッシュにリスナーが登録されていない場合 |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[キャッシュ操作発生] --> B{操作種別}
    B -->|put 既存キー| C[RemovalReason.REPLACED]
    B -->|invalidate| D[RemovalReason.INVALIDATED]
    B -->|eviction| E[RemovalReason.EVICTED]
    B -->|remove| F[RemovalReason.EXPLICIT]
    B -->|capacity| G[RemovalReason.CAPACITY]
    C --> H[RemovalNotification生成]
    D --> H
    E --> H
    F --> H
    G --> H
    H --> I[listener.onRemoval notification]
    I --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない。インメモリキャッシュからの通知 |

### テーブル別参照項目詳細

N/A

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | RDBは使用しない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | N/A |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー実行時例外 | onRemoval()内で例外がスローされた場合 | キャッシュ実装に依存（通常はログ出力して継続） |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（キャッシュ操作の都度発火） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし

## セキュリティ考慮事項

キャッシュのキーと値にはクエリ結果やインデックスデータが含まれる可能性がある。RemovalNotificationとRemovalListenerは@PublicApi(since = "1.0.0")としてマークされている。RemovalListenerは@ExperimentalApiとしてもマークされており、将来変更の可能性がある。onRemoval()がスレッドセーフである必要があるため、実装時に排他制御に注意が必要。

## 備考

- RemovalNotificationは@PublicApi(since = "1.0.0")としてマークされている
- RemovalListenerは@ExperimentalApi/@FunctionalInterfaceとしてマークされている
- RemovalReasonは6種類の列挙値を持つ：REPLACED, INVALIDATED, EVICTED, EXPLICIT, CAPACITY, RESTARTED
- RESTARTEDはテストフレームワーク用途（CachedIndexInputのクローズ時に使用）
- onRemoval()は複数スレッドから同時呼び出しされる可能性があるため、スレッドセーフな実装が必要（Javadocに明記）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | RemovalNotification.java | `server/src/main/java/org/opensearch/common/cache/RemovalNotification.java` | key/value/removalReasonの3フィールドとゲッターメソッド（行43-66） |
| 1-2 | RemovalReason.java | `server/src/main/java/org/opensearch/common/cache/RemovalReason.java` | 6種類の削除理由列挙値（行19-26） |
| 1-3 | RemovalListener.java | `server/src/main/java/org/opensearch/common/cache/RemovalListener.java` | onRemoval()メソッド定義とスレッドセーフティの注記（行44-50） |

**読解のコツ**: RemovalNotificationはシンプルなデータクラスであり、キー・値・削除理由の3つの情報を保持する。RemovalReasonの各列挙値の意味を理解することが重要。

#### Step 2: エントリーポイントを理解する

キャッシュ実装がRemovalNotificationを生成してリスナーに通知する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RemovalListener.java | `server/src/main/java/org/opensearch/common/cache/RemovalListener.java` | @FunctionalInterfaceによるラムダ対応（行43） |

**主要処理フロー**:
1. **RemovalNotification行49**: コンストラクタでkey, value, removalReasonを受け取る
2. **RemovalListener行50**: `onRemoval(RemovalNotification<K, V> notification)` - 通知受信

### プログラム呼び出し階層図

```
キャッシュ実装（put/remove/evict等）
    |
    +-- new RemovalNotification<>(key, value, removalReason)
    |
    +-- listener.onRemoval(notification)
            |
            +-- notification.getKey()
            +-- notification.getValue()
            +-- notification.getRemovalReason()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

キャッシュ操作  ───▶ RemovalNotification生成  ───▶ RemovalListener#onRemoval()
 (key, value,          (key, value,                     |
  RemovalReason)        removalReason)                   +───▶ リソース解放等の後処理
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RemovalNotification.java | `server/src/main/java/org/opensearch/common/cache/RemovalNotification.java` | ソース | 通知データクラス |
| RemovalReason.java | `server/src/main/java/org/opensearch/common/cache/RemovalReason.java` | ソース | 削除理由列挙型 |
| RemovalListener.java | `server/src/main/java/org/opensearch/common/cache/RemovalListener.java` | ソース | リスナーインターフェース |
