---
generated_at: 2026-02-03 18:00:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：10-SearchProgressListener通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **検索フェーズからの具体的な呼び出し箇所**：SearchQueryThenFetchAsyncAction等の呼び出し箇所の直接確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/search/SearchProgressListener.java` 行57-213
- E-02: `server/src/main/java/org/opensearch/action/search/SearchProgressListener.java` 行61-62（NOOP定義）
- E-03: `server/src/main/java/org/opensearch/action/search/SearchProgressListener.java` 行129-196（notifyXxxメソッド群）
- E-04: `server/src/main/java/org/opensearch/action/search/SearchProgressActionListener.java` 行43
- E-05: `server/src/main/java/org/opensearch/action/search/SearchTask.java` 行52-55
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行11

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 7つのprotectedコールバック（onListShards/onQueryResult/onQueryFailure/onPartialReduce/onFinalReduce/onFetchResult/onFetchFailure）を定義 | E-01 | ○ |
| C-02 | @PublicApi(since = "1.0.0")として公開APIに指定されている | E-01 | ○ |
| C-03 | NOOP静的フィールドが空の実装として提供されている | E-02 | ○ |
| C-04 | notifyXxx()メソッドはfinalで例外をキャッチし警告ログを出力するラッパー | E-03 | ○ |
| C-05 | SearchTaskのprogressListenerフィールドに設定される | E-05 | ○ |
| C-06 | デフォルトはSearchProgressListener.NOOP | E-05 | ○ |
| C-07 | SearchProgressActionListenerはSearchProgressListener+ActionListenerの複合抽象クラス | E-04 | ○ |
| C-08 | 抽象クラスであり各コールバックはデフォルト空実装を持つ | E-01 | ○ |
| C-09 | onListShards()でshardsフィールドを内部に保持する | E-03 | ○ |
| C-10 | buildSearchShards()ユーティリティメソッドでSearchShardリストを生成可能 | E-01 | ○ |
| C-11 | 警告ログメッセージは"Failed to execute progress listener on ..."形式 | E-03 | ○ |
| C-12 | notifyFinalReduceはprotected finalである | E-01 | ○ |
| C-13 | プロセス内コールバック通知である | E-01 | ○ |
| C-14 | 検索処理自体には影響しない（例外は握りつぶされる） | E-03 | ○ |
| C-15 | SearchQueryThenFetchAsyncAction/FetchSearchPhase/QueryPhaseResultConsumerから呼び出される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15の具体的な呼び出し箇所はSearchQueryThenFetchAsyncAction.java等を直接確認する必要がある
  - 候補：SearchQueryThenFetchAsyncAction.java / FetchSearchPhase.java / QueryPhaseResultConsumer.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 抽象クラスの定義とnotifyXxxラッパーの記述は正確
- 1: 中リスク - 検索フェーズからの呼び出し箇所の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] SearchProgressListenerの7つのコールバックがソースコードと一致するか確認
- [ ] notifyXxx()メソッドの例外ハンドリングが設計書の記述通りか確認
- [ ] SearchTask#progressListenerの初期値がNOOPであるか確認
- [ ] SearchQueryThenFetchAsyncAction等からの呼び出し箇所を確認
