---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：11-EarlyTerminatingListener通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **TopDocsCollectorContextでの生成元**：コード全文を確認していないため根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/search/query/EarlyTerminatingListener.java` (全文)
- E-02: `server/src/main/java/org/opensearch/search/query/EarlyTerminatingCollectorManager.java` (全文)
- E-03: `server/src/main/java/org/opensearch/search/query/TotalHitCountCollectorManager.java` (全文)
- E-04: `docs/code-to-docs/通知一覧/通知一覧.csv` (11行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EarlyTerminatingListenerはonEarlyTermination(int, boolean)の1メソッドを持つインターフェース | E-01 (17-24行目) | ○ |
| C-02 | maxCountHitsとforcedTerminationの2パラメータで通知される | E-01 (21-22行目) | ○ |
| C-03 | EarlyTerminatingCollectorManagerはreduce時にhasEarlyTerminatedを確認する | E-02 (49-54行目) | ○ |
| C-04 | 早期終了検出時にonEarlyTermination()を呼び出す | E-02 (58行目) | ○ |
| C-05 | 内部CollectorManagerがEarlyTerminatingListenerかをinstanceofで判定する | E-02 (75行目) | ○ |
| C-06 | TotalHitCountCollectorManagerはEarlyTerminatingListenerを実装している | E-03 (32-35行目) | ○ |
| C-07 | TotalHitCountCollectorManagerはonEarlyTerminationでterminatedAfterを設定する | E-03 (63-65行目) | ○ |
| C-08 | reduce時にterminatedAfterがnullでなければGREATER_THAN_OR_EQUAL_TOを設定 | E-03 (75-77行目) | ○ |
| C-09 | 早期終了時にQuerySearchResult.terminatedEarly(true)を設定する | E-02 (65行目) | ○ |
| C-10 | @opensearch.internalアノテーションが付与されている | E-01 (16行目) | ○ |
| C-11 | 送信方式は同期呼び出し | E-02 (reduce内での直接呼び出し) | ○ |
| C-12 | TopDocsCollectorContextがEarlyTerminatingCollectorManagerの生成元 | E-04 (通知一覧の備考) | △ |

## 4) 不足情報（Unknown / Missing）
- TopDocsCollectorContext.javaの全文を確認していないため、EarlyTerminatingCollectorManagerの生成箇所の詳細が未確認
  - 候補：TopDocsCollectorContext.java / QueryPhase.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースとその実装は明確に読み取れ、処理フローに矛盾はない

## 6) レビュアーチェックリスト（最小）
- [ ] TopDocsCollectorContext.javaでのEarlyTerminatingCollectorManager生成箇所を確認
- [ ] InternalProfileCollectorManagerでのEarlyTerminatingListener利用を確認
- [ ] Concurrent Segment Search有効時のみ本通知が意味を持つという記述の正確性を確認
