---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-sd_notify（READY）通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` (全文)
- E-02: `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` (全文)
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` (12行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onNodeStarted()でsd_notify(0, "READY=1")を呼び出す | E-01 (137行目) | ○ |
| C-02 | sd_notifyが負の値を返した場合RuntimeExceptionをスロー | E-01 (138-141行目) | ○ |
| C-03 | READY通知後にextenderスケジューラをキャンセルする | E-01 (143-144行目) | ○ |
| C-04 | enabled==falseの場合は何もしない | E-01 (133-136行目) | ○ |
| C-05 | OPENSEARCH_SD_NOTIFY環境変数でenabled判定 | E-01 (70, 73-83行目) | ○ |
| C-06 | 不正な環境変数値でRuntimeExceptionをスロー | E-01 (79-81行目) | ○ |
| C-07 | Libsystemd.sd_notifyはJNA経由のネイティブメソッド | E-02 (44-56行目) | ○ |
| C-08 | AccessController.doPrivilegedでセキュリティ制御 | E-02 (45行目) | ○ |
| C-09 | libsystemd.so.0をロードする | E-02 (45行目) | ○ |
| C-10 | sd_notifyメソッドでtraceレベルのログ出力 | E-01 (127行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] SystemdModulePluginTestsでREADY通知のテストケースが十分かを確認
- [ ] Node.start()からonNodeStarted()が呼ばれる正確なタイミングを確認
