---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 10
  claims_with_evidence: 10
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-sd_notify（EXTEND_TIMEOUT）通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：10 / 10、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/systemd/src/main/java/org/opensearch/systemd/SystemdModulePlugin.java` (全文)
- E-02: `modules/systemd/src/main/java/org/opensearch/systemd/Libsystemd.java` (全文)
- E-03: `docs/code-to-docs/通知一覧/通知一覧.csv` (13行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 15秒間隔でEXTEND_TIMEOUT_USEC=30000000を送信 | E-01 (116-121行目), E-03 | ○ |
| C-02 | createComponents()内でscheduleWithFixedDelayでスケジュール設定 | E-01 (116行目) | ○ |
| C-03 | sd_notify失敗時は警告ログのみ出力 | E-01 (118-119行目) | ○ |
| C-04 | enabled==falseの場合はextenderをnullに設定 | E-01 (105-107行目) | ○ |
| C-05 | ThreadPool.Names.SAMEスレッドで実行 | E-01 (121行目) | ○ |
| C-06 | READY通知送信後にextender.cancel()でキャンセル | E-01 (143行目) | ○ |
| C-07 | TimeValue.timeValueSeconds(15)で15秒間隔を設定 | E-01 (121行目) | ○ |
| C-08 | 延長値は30000000マイクロ秒（30秒） | E-01 (117行目) | ○ |
| C-09 | コメントにsystemdのデフォルト60秒タイムアウトの説明あり | E-01 (109-115行目) | ○ |
| C-10 | SetOnceでextenderを管理 | E-01 (85行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] systemdのデフォルトタイムアウト値（60秒）がsystemdバージョンによって異なるか確認
- [ ] 15秒の送信間隔と30秒の延長値の組み合わせが適切か確認
