---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：15-UncaughtExceptionHandler通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **Bootstrap.javaでのハンドラ登録**：登録箇所の詳細が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/bootstrap/OpenSearchUncaughtExceptionHandler.java` (全文)
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` (15行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Thread.UncaughtExceptionHandlerを実装 | E-01 (48行目) | ○ |
| C-02 | isFatalUncaught()はErrorクラスかどうかで判定 | E-01 (78-80行目) | ○ |
| C-03 | 致命的エラー時は「fatal error in thread」メッセージ | E-01 (83行目) | ○ |
| C-04 | 非致命的エラー時は「uncaught exception in thread」メッセージ | E-01 (92行目) | ○ |
| C-05 | InternalErrorの終了コードは128 | E-01 (60行目) | ○ |
| C-06 | OutOfMemoryErrorの終了コードは127 | E-01 (62行目) | ○ |
| C-07 | StackOverflowErrorの終了コードは126 | E-01 (64行目) | ○ |
| C-08 | UnknownErrorの終了コードは125 | E-01 (66行目) | ○ |
| C-09 | IOErrorの終了コードは124 | E-01 (68行目) | ○ |
| C-10 | Runtime.halt()でシャットダウンフックなしで停止 | E-01 (116行目) | ○ |
| C-11 | AccessController.doPrivilegedでhaltを実行 | E-01 (101行目) | ○ |
| C-12 | Bootstrap.javaでハンドラが登録される | E-02 (通知一覧備考) | △ |

## 4) 不足情報（Unknown / Missing）
- Bootstrap.javaでの具体的なハンドラ登録コード行を未確認
  - 候補：Bootstrap.java / Security.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理ロジックはすべてソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Bootstrap.javaでのThread.setDefaultUncaughtExceptionHandler()呼び出し箇所を確認
- [ ] 終了コードの体系がシステム運用ドキュメントと整合しているか確認
- [ ] Terminal.DEFAULT.flush()がhalt前に確実に完了するか確認
