---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：16-DeprecationHandler通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **XContentParserでの非推奨フィールド検出メカニズム**：具体的な呼び出し箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `libs/core/src/main/java/org/opensearch/core/xcontent/DeprecationHandler.java` (全文)
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` (16行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3つのコールバックメソッドが定義されている | E-01 (141, 149, 156行目) | ○ |
| C-02 | THROW_UNSUPPORTED_OPERATIONはUnsupportedOperationExceptionをスロー | E-01 (53-114行目) | ○ |
| C-03 | IGNORE_DEPRECATIONSは空実装 | E-01 (119-134行目) | ○ |
| C-04 | parserNameがnullの場合は簡略メッセージ | E-01 (56-72行目) | ○ |
| C-05 | @PublicApi(since = "1.0.0")が付与 | E-01 (45行目) | ○ |
| C-06 | usedDeprecatedNameはフィールド名変更を通知 | E-01 (136-141行目, Javadoc) | ○ |
| C-07 | usedDeprecatedField（代替あり）はフィールド置換を通知 | E-01 (143-149行目, Javadoc) | ○ |
| C-08 | usedDeprecatedField（代替なし）はフィールド完全廃止を通知 | E-01 (151-156行目, Javadoc) | ○ |
| C-09 | Supplier<XContentLocation>で位置情報を遅延取得 | E-01 (メソッドシグネチャ) | ○ |
| C-10 | XContentParserがフィールド解決時に非推奨フィールドを検出して通知する | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- XContentParser内で具体的にDeprecationHandlerのコールバックが呼び出される箇所を未確認
  - 候補：XContentParser実装クラス / ObjectParser / AbstractObjectParser

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - インターフェースの定義と既定実装は明確に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] XContentParser実装でDeprecationHandlerが呼び出される具体的な箇所を確認
- [ ] カスタムDeprecationHandler実装の有無を確認
- [ ] THROW_UNSUPPORTED_OPERATIONが使用されるコンテキスト（テスト/strictモード）を確認
