---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：17-PersistentTasksNodeService通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **PersistentTasksExecutorの具体実装**：具体的なタスク実装の呼び出し先が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/persistent/PersistentTasksNodeService.java` (全文)
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` (17行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClusterStateListenerを実装 | E-01 (68行目) | ○ |
| C-02 | STATE_NOT_RECOVERED_BLOCKチェックでゲートウェイ回復前はスキップ | E-01 (92-96行目) | ○ |
| C-03 | PersistentTasksCustomMetadataの変更を検出 | E-01 (97-98, 123行目) | ○ |
| C-04 | ローカルノードに割り当てられたタスクを走査 | E-01 (129行目) | ○ |
| C-05 | 新規タスクはstartTask()で開始 | E-01 (135行目) | ○ |
| C-06 | TaskManager.register()でタスク登録 | E-01 (210行目) | ○ |
| C-07 | nodePersistentTasksExecutor.executeTask()でタスク実行委譲 | E-01 (237行目) | ○ |
| C-08 | タスク登録失敗時にnotifyMasterOfFailedTaskで通知 | E-01 (222行目) | ○ |
| C-09 | sendCompletionRequestでクラスタマネージャに失敗通知 | E-01 (261-264行目) | ○ |
| C-10 | cancelTask()でrunningTasksから削除後にキャンセル | E-01 (296-300行目) | ○ |
| C-11 | 完了タスクはrunningTasksから削除のみ | E-01 (166行目) | ○ |
| C-12 | 状態遷移モデルがコメントで定義されている | E-01 (99-121行目) | ○ |
| C-13 | Statusクラス（Task.Status実装）が内部クラスとして定義 | E-01 (333-387行目) | ○ |
| C-14 | PersistentTasksExecutorが具体的なタスクロジックを実行 | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- PersistentTasksExecutorの具体的な実装クラス（どのようなタスクが永続タスクとして登録されるか）を未確認
  - 候補：各プラグインのPersistentTasksExecutor実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な処理フローとエラー処理はソースコードから明確に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] PersistentTasksExecutorの具体実装（例：CrossClusterReplicationTask等）を確認
- [ ] NodePersistentTasksExecutor.executeTask()の実装を確認
- [ ] AllocatedPersistentTaskの状態遷移（STARTED/PENDING_CANCEL/COMPLETED）を確認
