---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：18-LeaderChecker通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **CoordinatorでのonLeaderFailure処理**：Coordinator内のCANDIDATE遷移の詳細が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/coordination/LeaderChecker.java` (全文)
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` (18行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトのチェック間隔は1000ms | E-01 (92行目) | ○ |
| C-02 | デフォルトのチェックタイムアウトは10000ms | E-01 (100行目) | ○ |
| C-03 | デフォルトのリトライ回数は3 | E-01 (110行目) | ○ |
| C-04 | ConnectTransportExceptionは即座にleaderFailed | E-01 (308-311行目) | ○ |
| C-05 | NodeHealthCheckFailureExceptionは即座にleaderFailed | E-01 (312-315行目) | ○ |
| C-06 | 連続失敗がretryCount以上でleaderFailed | E-01 (317-332行目) | ○ |
| C-07 | leaderFailed()でisClosed CAS操作 | E-01 (357行目) | ○ |
| C-08 | generic ThreadPoolでonLeaderFailure実行 | E-01 (359行目) | ○ |
| C-09 | leaderCheckFailureCounterメトリクス記録 | E-01 (358行目) | ○ |
| C-10 | TransportConnectionListenerでノード切断検出 | E-01 (157-162行目) | ○ |
| C-11 | handleLeaderCheck()で3段階の検証 | E-01 (210-236行目) | ○ |
| C-12 | leaderCheckTimeout設定はDynamic属性 | E-01 (104行目) | ○ |
| C-13 | 成功時にfailureCountSinceLastSuccess=0にリセット | E-01 (298行目) | ○ |
| C-14 | アクション名は"internal:coordination/fault_detection/leader_check" | E-01 (87行目) | ○ |
| C-15 | CoordinatorがCANDIDATEモードに遷移する | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- Coordinator.javaでのonLeaderFailureハンドラの具体的な実装を未確認
  - 候補：Coordinator.java / CoordinationState.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - LeaderCheckerの処理フローはソースコードから網羅的に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Coordinator.javaでのonLeaderFailureコールバック実装を確認
- [ ] leaderCheckTimeout動的変更時の挙動を確認
- [ ] ネットワークパーティション時のリーダーチェック挙動を確認
