---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-GlobalCheckpointListeners通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **IndexShardでのglobalCheckpointUpdated呼び出し**：具体的な呼び出し箇所が未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/shard/GlobalCheckpointListeners.java` (全文)
- E-02: `docs/code-to-docs/通知一覧/通知一覧.csv` (20行目)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GlobalCheckpointListenerはexecutor()とaccept(long, Exception)を持つ | E-01 (81, 92行目) | ○ |
| C-02 | add()でclosed時はIndexShardClosedExceptionで即時通知 | E-01 (132-134行目) | ○ |
| C-03 | add()でlastKnownGCP >= waitingForなら即時通知 | E-01 (136-138行目) | ○ |
| C-04 | タイムアウト付き登録でScheduledFutureを設定 | E-01 (143-161行目) | ○ |
| C-05 | globalCheckpointUpdated()でlastKnownGCPを更新 | E-01 (207行目) | ○ |
| C-06 | 待機値<=GCPのリスナーを抽出して通知 | E-01 (221-224行目) | ○ |
| C-07 | close()で全リスナーにUNASSIGNED_SEQ_NOとIndexShardClosedExceptionで通知 | E-01 (171-172行目) | ○ |
| C-08 | notifyListener()でlistener.executor().execute()で非同期実行 | E-01 (245行目) | ○ |
| C-09 | リスナー内例外発生時に警告ログ出力 | E-01 (248-261行目) | ○ |
| C-10 | LinkedHashMapで登録順序を保持 | E-01 (98行目) | ○ |
| C-11 | synchronized(this)でスレッド安全性確保 | E-01 (131, 167, 199行目) | ○ |
| C-12 | @PublicApi(since = "1.0.0")が付与 | E-01 (73行目) | ○ |
| C-13 | lastKnownGlobalCheckpointはUNASSIGNED_SEQ_NO(-2)で初期化 | E-01 (99行目) | ○ |
| C-14 | FutureUtils.cancel()でタイムアウトFutureをキャンセル | E-01 (236行目) | ○ |
| C-15 | IndexShardがGlobalCheckpointListenersを保持しglobalCheckpointUpdatedを呼び出す | E-02 | △ |

## 4) 不足情報（Unknown / Missing）
- IndexShard.javaでのglobalCheckpointUpdated()呼び出し箇所を未確認
  - 候補：IndexShard.java / ReplicationTracker.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - GlobalCheckpointListenersの全メソッドがソースコードから明確に読み取れる

## 6) レビュアーチェックリスト（最小）
- [ ] IndexShard.javaでのglobalCheckpointUpdated()呼び出し箇所を確認
- [ ] GlobalCheckpointListenerの具体的な実装クラスを確認
- [ ] タイムアウト処理と通知処理の競合状態（race condition）が適切にハンドルされているか確認
- [ ] ScheduledExecutorServiceがシャードクローズ後に適切にシャットダウンされるか確認
