---
generated_at: 2026-02-03 18:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-ActionListener通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行52-53（@PublicApi、インターフェース定義）
- E-02: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行58（onResponse定義）
- E-03: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行63（onFailure定義）
- E-04: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行74-93（wrap定義）
- E-05: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行170-202（map定義）
- E-06: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行227-241（onResponse一括通知）
- E-07: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行247-257（onFailure一括通知）
- E-08: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行320-332（notifyOnce）
- E-09: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行341-360（completeWith）
- E-10: `libs/core/src/main/java/org/opensearch/core/action/ActionListener.java` 行362-364（noOp）
- E-11: `docs/code-to-docs/通知一覧/通知一覧.csv` 行7

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | onResponse(Response)とonFailure(Exception)の2メソッドを定義する | E-02, E-03 | ○ |
| C-02 | @PublicApi(since = "1.0.0")として公開APIに指定されている | E-01 | ○ |
| C-03 | ジェネリクス型パラメータ<Response>により任意の応答型に対応 | E-01 | ○ |
| C-04 | wrap(CheckedConsumer, Consumer)でラムダ式からリスナー生成可能 | E-04 | ○ |
| C-05 | map()でレスポンス変換が可能 | E-05 | ○ |
| C-06 | onResponse(Iterable, response)で複数リスナーへの一括成功通知が可能 | E-06 | ○ |
| C-07 | onFailure(Iterable, failure)で複数リスナーへの一括失敗通知が可能 | E-07 | ○ |
| C-08 | notifyOnce()でNotifyOnceListenerにラップし二重通知防止可能 | E-08 | ○ |
| C-09 | completeWith()で同期コードからリスナーを完了可能 | E-09 | ○ |
| C-10 | noOp()で何もしないリスナーを生成可能 | E-10 | ○ |
| C-11 | wrap()で作成されたリスナーはonResponse内の例外をonFailureに委譲する | E-04 | ○ |
| C-12 | 一括通知でリスナー例外が発生した場合ExceptionsHelperで集約される | E-06 | ○ |
| C-13 | delegateFailure/delegateResponseでリスナー合成が可能 | E-05 | ○ |
| C-14 | runAfter/runBeforeでコールバック前後の処理追加が可能 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ActionListenerのインターフェース定義がソースコードと一致するか確認
- [ ] ユーティリティメソッド群の振る舞いが記述通りか確認
