---
generated_at: 2026-02-03 18:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-FileChangesListener通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/watcher/FileChangesListener.java` 行41-76
- E-02: `server/src/main/java/org/opensearch/watcher/FileWatcher.java` 行52-87
- E-03: `server/src/main/java/org/opensearch/watcher/FileWatcher.java` 行103-170（checkAndNotify）
- E-04: `server/src/main/java/org/opensearch/watcher/FileWatcher.java` 行268-299（通知メソッド群）
- E-05: `server/src/main/java/org/opensearch/watcher/AbstractResourceWatcher.java` 行44-95
- E-06: `docs/code-to-docs/通知一覧/通知一覧.csv` 行10

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 7つのコールバック（onFileInit/onDirectoryInit/onFileCreated/Deleted/Changed/onDirectoryCreated/Deleted）を定義する | E-01 | ○ |
| C-02 | @opensearch.internalとしてマークされている | E-01 | ○ |
| C-03 | 全メソッドがデフォルト実装（空）を持つ | E-01 | ○ |
| C-04 | FileWatcherはAbstractResourceWatcherを継承する | E-02 | ○ |
| C-05 | CopyOnWriteArrayListでリスナーを管理する | E-05 | ○ |
| C-06 | ファイル変更はlastModifiedTimeとsizeの比較で検出される | E-03 | ○ |
| C-07 | 例外時は警告ログ（"cannot notify file changes listener"）を出力して次のリスナーの処理を継続 | E-04 | ○ |
| C-08 | clearState()で監視状態をリセット可能 | E-02 | ○ |
| C-09 | ファイルがディレクトリに置換された場合はonFileDeleted→onDirectoryCreatedの順で通知 | E-03 | ○ |
| C-10 | 初期化時にはonFileInit/onDirectoryInitが呼ばれる | E-02, E-04 | ○ |
| C-11 | Pathオブジェクトが各コールバックに渡される | E-01 | ○ |
| C-12 | NIO2のWatchServiceは未使用（コメントに記載） | E-03 | ○ |
| C-13 | FileObserver内部クラスでファイル状態を追跡する | E-03 | ○ |
| C-14 | プロセス内コールバック通知である | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] FileChangesListenerの7つのコールバックがソースコードと一致するか確認
- [ ] FileObserver#checkAndNotify()の状態遷移ロジックが正確か確認
- [ ] 通知時の例外処理が設計書の記述通りか確認
