---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 62
  claims_with_evidence: 57
  claims_without_evidence: 5
confidence_derived: 0.92
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された業務運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：57 / 62、根拠なし：5
- 優先レビュー（高）
  1. **C-05 ユーザー種別の権限定義**：Security Pluginに依存するため根拠不足
  2. **C-42 バルク操作の推奨バッチサイズ**：公式ドキュメントの推奨値だがコード根拠なし
  3. **C-55 サーキットブレーカーの閾値**：設定依存のため具体的な閾値は未記載
  4. **C-58 スナップショットリポジトリの検証コマンド**：プラグイン依存で動作が異なる可能性
  5. **C-60 OpenSearch Dashboards接続ポート**：デフォルト値は環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` — 95件の業務要件
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` — 167件のREST APIエンドポイント
- E-03: `docs/code-to-docs/画面一覧/画面遷移図.md` — 画面遷移フロー
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` — 208件のマッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` — 130件の機能定義
- E-06: `docs/code-to-docs/機能設計書/` — 240+件の機能設計書
- E-07: `docs/code-to-docs/画面設計書/` — 167件の画面設計書
- E-08: `server/src/main/java/org/opensearch/identity/` — 認証・認可フレームワーク
- E-09: `rest-api-spec/` — REST API仕様定義
- E-10: `server/src/main/java/org/opensearch/rest/` — REST APIハンドラ実装
- E-11: `server/src/main/java/org/opensearch/action/` — アクション実装
- E-12: `server/src/main/java/org/opensearch/cluster/` — クラスタ管理実装
- E-13: `server/src/main/java/org/opensearch/index/` — インデックス管理実装
- E-14: `server/src/main/java/org/opensearch/search/` — 検索エンジン実装
- E-15: `server/src/main/java/org/opensearch/ingest/` — インジェストパイプライン実装
- E-16: `server/src/main/java/org/opensearch/snapshots/` — スナップショット管理実装
- E-17: `plugins/repository-s3/` — S3リポジトリプラグイン
- E-18: `plugins/repository-gcs/` — GCSリポジトリプラグイン
- E-19: `plugins/repository-azure/` — Azureリポジトリプラグイン
- E-20: `plugins/repository-hdfs/` — HDFSリポジトリプラグイン
- E-21: `modules/lang-painless/` — Painlessスクリプト言語
- E-22: `modules/lang-mustache/` — Mustacheテンプレート言語
- E-23: `modules/ingest-common/` — 共通インジェストプロセッサ
- E-24: `modules/ingest-geoip/` — GeoIPプロセッサ
- E-25: `modules/ingest-user-agent/` — User-Agentプロセッサ
- E-26: `modules/transport-netty4/` — Netty4トランスポート実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OpenSearchはApache License 2.0で公開されている | E-01 (LICENSE.txt) | ○ |
| C-02 | Apache Luceneをベースに構築されている | E-13, E-14 | ○ |
| C-03 | REST APIですべての操作が可能 | E-09, E-10 | ○ |
| C-04 | デフォルトポートは9200（REST API）、9300（Transport） | E-26, E-10 | ○ |
| C-05 | ユーザー種別（管理者、データエンジニア、開発者、運用担当者） | **根拠なし** | △ |
| C-06 | 業務要件は12カテゴリ95件 | E-01 | ○ |
| C-07 | REST APIエンドポイントは167件 | E-02 | ○ |
| C-08 | 機能数は130件23カテゴリ | E-05 | ○ |
| C-09 | クラスタヘルスはgreen/yellow/redの3段階 | E-12 | ○ |
| C-10 | インデックス名に使用禁止文字がある | E-13 | ○ |
| C-11 | テンプレートにpriority設定が可能 | E-06, E-09 | ○ |
| C-12 | Composableインデックステンプレートが利用可能 | E-09, E-06 | ○ |
| C-13 | データストリーム機能が利用可能 | E-09, E-05 | ○ |
| C-14 | ドキュメントCRUD操作（登録・取得・更新・削除） | E-11, E-07 | ○ |
| C-15 | バルク操作はNDJSON形式 | E-09, E-06 | ○ |
| C-16 | リインデックスAPIが利用可能 | E-09, E-01 (BR-008) | ○ |
| C-17 | matchクエリによる全文検索 | E-14 | ○ |
| C-18 | termクエリによる完全一致検索 | E-14 | ○ |
| C-19 | boolクエリによる複合条件検索 | E-14 | ○ |
| C-20 | スクロール検索機能 | E-09, E-02 (画面No.22-23) | ○ |
| C-21 | Point-in-Time（PIT）検索機能 | E-09, E-02 (画面No.24-26) | ○ |
| C-22 | バケットアグリゲーション（termsなど） | E-14, E-05 | ○ |
| C-23 | メトリクスアグリゲーション（avg, max, minなど） | E-14, E-05 | ○ |
| C-24 | 日時ヒストグラムアグリゲーション | E-14 | ○ |
| C-25 | マルチ検索（_msearch）機能 | E-09, E-02 (画面No.27) | ○ |
| C-26 | サジェスト機能 | E-14, E-01 (BR-018) | ○ |
| C-27 | ハイライト表示機能 | E-14, E-01 (BR-017) | ○ |
| C-28 | ソースフィルタリング（_source指定） | E-14 | ○ |
| C-29 | クラスタヘルス取得API | E-09, E-02 (画面No.91) | ○ |
| C-30 | クラスタ状態取得API | E-09, E-02 (画面No.92) | ○ |
| C-31 | ノード情報取得API | E-09, E-02 (画面No.112) | ○ |
| C-32 | ノード統計取得API | E-09, E-02 (画面No.113) | ○ |
| C-33 | ホットスレッド取得API | E-09, E-02 (画面No.114) | ○ |
| C-34 | シャード割り当て説明API | E-09, E-02 (画面No.96) | ○ |
| C-35 | シャード再配置（_cluster/reroute）API | E-09, E-02 (画面No.97) | ○ |
| C-36 | クラスタ設定のpersistentとtransientの区別 | E-12 | ○ |
| C-37 | タスク管理API（一覧・詳細・キャンセル） | E-09, E-02 (画面No.118-120) | ○ |
| C-38 | リフレッシュ・フラッシュ・フォースマージ・キャッシュクリアAPI | E-09, E-02 (画面No.75-79) | ○ |
| C-39 | ノードデコミッション機能 | E-12, E-01 (BR-055) | ○ |
| C-40 | スナップショットリポジトリ登録API | E-09, E-02 (画面No.121) | ○ |
| C-41 | 対応リポジトリタイプ（fs, s3, gcs, azure, hdfs） | E-17, E-18, E-19, E-20 | ○ |
| C-42 | バルク操作の推奨バッチサイズ（1,000〜5,000件） | **根拠なし** | △ |
| C-43 | スナップショット作成・リストアAPI | E-09, E-16 | ○ |
| C-44 | リストア時のrename_pattern/rename_replacement | E-09, E-16 | ○ |
| C-45 | インジェストパイプラインの作成・シミュレーションAPI | E-09, E-15, E-02 (画面No.133-135) | ○ |
| C-46 | User-Agentプロセッサ | E-25 | ○ |
| C-47 | GeoIPプロセッサ | E-24 | ○ |
| C-48 | Painlessスクリプト言語 | E-21, E-01 (BR-071) | ○ |
| C-49 | Mustacheテンプレート | E-22, E-01 (BR-071) | ○ |
| C-50 | 検索テンプレート機能 | E-09, E-02 (画面No.28) | ○ |
| C-51 | CAT APIによるテキスト形式出力 | E-09, E-02 (画面No.147-167) | ○ |
| C-52 | ?vパラメータでヘッダー行表示 | E-09 | ○ |
| C-53 | index_not_found_exceptionエラー | E-13, E-10 | ○ |
| C-54 | mapper_parsing_exceptionエラー | E-13 | ○ |
| C-55 | circuit_breaking_exceptionエラーの閾値 | **根拠なし** | △ |
| C-56 | cluster_block_exceptionとread-only解除方法 | E-12, E-13 | ○ |
| C-57 | version_conflict_engine_exceptionとretry_on_conflict | E-11 | ○ |
| C-58 | スナップショットリポジトリの_verify API | **根拠なし** | △ |
| C-59 | Basic認証・Bearer Token認証サポート | E-08 | ○ |
| C-60 | OpenSearch Dashboardsのデフォルトポート5601 | **根拠なし** | △ |
| C-61 | マッピングで既存フィールドの型変更不可 | E-13 | ○ |
| C-62 | エイリアス一括操作API | E-09, E-02 (画面No.49) | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-05 ユーザー種別の権限定義**: OpenSearch本体にはロールベースの権限モデルが組み込まれていない。Security Plugin（opensearch-security）の設定に依存するため、具体的な権限定義はコードから特定できない
  - 候補：Security Plugin設計書 / 公式セキュリティドキュメント / 組織のセキュリティポリシー文書
- **C-42 バルク操作の推奨バッチサイズ**: 一般的なベストプラクティスとして記載したが、コード内に明示的な推奨値は存在しない
  - 候補：OpenSearch公式パフォーマンスチューニングガイド / ベンチマークテスト結果
- **C-55 サーキットブレーカーの閾値**: デフォルト設定値はコード内に存在するが、運用環境ごとに異なるため具体的な記載を避けた
  - 候補：`server/src/main/java/org/opensearch/common/breaker/` 内のデフォルト値
- **C-58 スナップショットリポジトリの_verify API**: REST API仕様は存在するが、プラグインごとの検証動作が異なる可能性がある
  - 候補：各リポジトリプラグインの実装コード / 公式ドキュメント
- **C-60 OpenSearch Dashboardsのポート**: Dashboardsは別プロジェクトであり、本リポジトリには含まれない
  - 候補：OpenSearch Dashboardsリポジトリ / 公式インストールガイド

## 5) リスクフラグ（レビュー観点）
- 0: **業務フロー構造**: テンプレートの「案内・通知→申請→処理」構造をOpenSearchの「インデックス設計→データ投入→検索→管理」に適応した。本システムの特性に合致しているか確認が必要
- 0: **APIリクエスト例**: REST API仕様とソースコードに基づいて記載。パラメータの網羅性は画面設計書に依存
- 1: **Security Plugin依存の記述**: 認証・認可に関する記述はSecurity Pluginの設定に依存するため、実環境と異なる場合がある
- 0: **エラーメッセージ**: ソースコードに基づくエラーメッセージだが、バージョンにより変更される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] 業務フロー（STEP1〜5）がOpenSearchの実際の利用パターンに合致しているか
- [ ] ユーザー種別（管理者、データエンジニア、開発者、運用担当者）が組織の実態に合っているか
- [ ] REST APIリクエスト例が正しいか（特にパラメータ名とデータ型）
- [ ] Security Pluginの認証方式が実環境の設定と一致しているか
- [ ] エラーメッセージと対処法が最新バージョンに合致しているか
- [ ] バルク操作の推奨バッチサイズが実環境のスペックに適しているか
- [ ] スナップショットのリポジトリタイプが実環境で使用しているものをカバーしているか
